/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.wizards;

import com.backbase.bxmleditor.wizards.BStartBean;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewBStartWizardPageTwo
extends WizardPage {
    private static final Logger LOG;
    private Text pageName;
    private ISelection selection;
    private BStartBean bstartBean;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.wizards.NewBStartWizardPageTwo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public NewBStartWizardPageTwo(ISelection selection) {
        super("wizardIncludePage");
        LOG.info((Object)("selection :: " + selection));
        this.setTitle("New Backbase BXML include file");
        this.setDescription("The BXML include file");
        this.selection = selection;
        this.bstartBean = new BStartBean();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(1);
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
        Label label = new Label(container, 0);
        label.setText("&File name:");
        this.pageName = new Text(container, 2052);
        gd = new GridData(1);
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
        this.pageName.setLayoutData((Object)gd);
        this.pageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBStartWizardPageTwo.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.bstartBean.setPath(container.getFullPath().toString());
            }
        }
        this.bstartBean.setName("BXML Untitled");
        this.pageName.setText(this.bstartBean.getName());
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.bstartBean.setPath(((Path)result[0]).toOSString());
        }
    }

    private void handleExtendBrowse() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 65536);
        String file = fileDialog.open();
        if (file != null) {
            Path path = new Path(file);
            this.bstartBean.setPath(path.toOSString());
            this.dialogChanged();
        }
    }

    private void dialogChanged() {
        String ext;
        String containerName = this.bstartBean.getPath();
        String fileName = this.pageName.getText();
        this.bstartBean.setName(fileName);
        this.bstartBean.setPath(containerName);
        if (containerName.length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(String.valueOf(fileName) + ".xml"));
        if (file.exists()) {
            this.updateStatus("File already exists!");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc > 0 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("xml")) {
            this.updateStatus("File extension will be added automatically \"xml\"");
            return;
        }
        this.updateStatus(null);
    }

    private boolean validatePage() {
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public BStartBean getBStartBean() {
        return this.bstartBean;
    }
}

