/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.dictionary;

import com.backbase.bxmleditor.dictionary.Function;
import com.backbase.bxmleditor.dictionary.Parameter;
import com.backbase.bxmleditor.dictionary.Procedure;
import com.backbase.bxmleditor.dictionary.Tag;
import com.backbase.bxmleditor.dictionary.Value;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DictionaryContentHandler
implements ContentHandler {
    private Locator locator;
    private Map dtags;
    private Map dfunctions;
    private String currenttag = "";
    private Procedure currentitem = null;
    private Parameter paramitem = null;

    public DictionaryContentHandler(Map tags, Map functions) {
        this.dtags = tags;
        this.dfunctions = functions;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private boolean parseBoolean(String bstring) {
        return bstring.equalsIgnoreCase("true") || bstring.equalsIgnoreCase("yes");
    }

    public void startElement(String namespace, String localName, String str2, Attributes attributes) throws SAXException {
        this.currenttag = str2;
        if (str2.equals("tag")) {
            byte creator = 0;
            String name = "";
            boolean single = false;
            boolean xmlstyle = false;
            int x = 0;
            while (x < attributes.getLength()) {
                String attrname = attributes.getQName(x);
                if (attrname.equals("creator")) {
                    creator = Byte.parseByte(attributes.getValue(x));
                } else if (attrname.equals("name")) {
                    name = attributes.getValue(x);
                } else if (attrname.equals("single")) {
                    single = this.parseBoolean(attributes.getValue(x));
                } else if (attrname.equals("xmlstyle")) {
                    xmlstyle = this.parseBoolean(attributes.getValue(x));
                }
                ++x;
            }
            this.currentitem = new Tag(name, single, xmlstyle, creator);
        } else if (str2.equals("function")) {
            byte creator = 0;
            String name = "";
            String returns = "";
            int x = 0;
            while (x < attributes.getLength()) {
                String attrname = attributes.getQName(x);
                if (attrname.equals("creator")) {
                    creator = Byte.parseByte(attributes.getValue(x));
                } else if (attrname.equals("name")) {
                    name = attributes.getValue(x);
                } else if (attrname.equals("returns")) {
                    returns = attributes.getValue(x);
                }
                ++x;
            }
            this.currentitem = new Function(name, returns, creator);
        } else if (str2.equals("parameter")) {
            String name = "";
            String type = "";
            boolean required = false;
            int x = 0;
            while (x < attributes.getLength()) {
                String attrname = attributes.getQName(x);
                if (attrname.equals("type")) {
                    type = attributes.getValue(x);
                } else if (attrname.equals("name")) {
                    name = attributes.getValue(x);
                } else if (attrname.equals("required")) {
                    required = this.parseBoolean(attributes.getValue(x));
                }
                ++x;
            }
            this.paramitem = new Parameter(name, type, required);
        } else if (str2.equals("value")) {
            String option = attributes.getValue(0);
            if (option != null && this.paramitem != null) {
                this.paramitem.addValue(new Value(option));
            }
        } else {
            str2.equals("help");
        }
    }

    public void endElement(String str, String str1, String str2) throws SAXException {
        if (str2.equals("tag")) {
            if (this.currentitem != null) {
                this.dtags.put(this.currentitem.getName(), this.currentitem);
            }
        } else if (str2.equals("function")) {
            if (this.currentitem != null) {
                this.dfunctions.put(this.currentitem.getName(), this.currentitem);
            }
        } else if (str2.equals("parameter")) {
            if (this.currentitem != null && this.paramitem != null) {
                this.currentitem.addParameter(this.paramitem);
            }
            this.paramitem = null;
        } else if (!str2.equals("value")) {
            str2.equals("help");
        }
        this.currenttag = "";
    }

    public void startPrefixMapping(String str, String str1) throws SAXException {
    }

    public void endPrefixMapping(String str) throws SAXException {
    }

    public void characters(char[] values, int start, int length) throws SAXException {
        if (this.currenttag.equals("help")) {
            StringBuffer resvalue = new StringBuffer();
            int x = start;
            while (x < start + length) {
                resvalue.append(values[x]);
                ++x;
            }
            if (this.currentitem != null && this.paramitem == null) {
                if (resvalue.toString().trim().length() > 0) {
                    this.currentitem.setHelp(String.valueOf(this.currentitem.getHelp()) + " " + resvalue.toString().trim().replace('\t', ' ') + "\n");
                }
            } else if (this.currentitem != null && this.paramitem != null && resvalue.toString().trim().length() > 0) {
                this.paramitem.setHelp(String.valueOf(this.paramitem.getHelp()) + " " + resvalue.toString().trim().replace('\t', ' ') + "\n");
            }
        }
    }

    public void endDocument() throws SAXException {
    }

    public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
    }

    public void processingInstruction(String str, String str1) throws SAXException {
    }

    public void skippedEntity(String str) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }
}

