/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.editors;

import com.backbase.bxmleditor.BILPluginImages;
import com.backbase.bxmleditor.dictionary.DictionaryManager;
import com.backbase.bxmleditor.dictionary.Function;
import com.backbase.bxmleditor.dictionary.Parameter;
import com.backbase.bxmleditor.dictionary.SyntaxDictionary;
import com.backbase.bxmleditor.dictionary.Tag;
import com.backbase.bxmleditor.dictionary.Value;
import com.backbase.bxmleditor.preferences.BILPreferenceManager;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class BILCompletionProcessor
implements IContentAssistProcessor {
    private static final short TAGTYPE = 0;
    private static boolean is_biltag_s = false;
    private static boolean is_biltag_b = false;
    private static final Logger LOG;
    private static final short ATTRTYPE = 1;
    private static final short VALUETYPE = 2;
    private ContentAssistant assistant;
    protected IContextInformationValidator validator = new Validator();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.editors.BILCompletionProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public BILCompletionProcessor(ContentAssistant assistant) {
        this.assistant = assistant;
    }

    protected ICompletionProposal[] getAttributeValueProposals(SyntaxDictionary syntax, String inputText, int indexOfFirstSpace, int docOffset) {
        int lastSpace = inputText.lastIndexOf(" ");
        int quotes = inputText.lastIndexOf("\"");
        String valueSoFar = "";
        if (quotes != -1) {
            valueSoFar = inputText.substring(quotes + 1, inputText.length());
        } else {
            quotes = inputText.length() - 2;
        }
        String attribute = inputText.substring(lastSpace + 1, quotes - 1);
        String tag = inputText.substring(0, indexOfFirstSpace);
        Set attrProps = syntax.getFilteredAttributeValues(tag, attribute, valueSoFar);
        if (attrProps != null) {
            if (attrProps.size() > 0 && ((Value)attrProps.toArray()[0]).getValue().compareTo(valueSoFar) == 0) {
                return null;
            }
            return this.makeSetToProposal(attrProps, docOffset, (short)2, valueSoFar.length());
        }
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        try {
            String limiting = "";
            String tagnamespace = "";
            SyntaxDictionary syntax = null;
            boolean biltag = false;
            boolean htmltag = false;
            String invoker = "";
            if (documentOffset > 0) {
                invoker = viewer.getDocument().get(documentOffset - 1, 1);
            }
            try {
                this.assistant.enableAutoActivation(true);
            }
            catch (Exception exception) {}
            IDocument document = viewer.getDocument();
            int start = invoker.equals(">") ? document.getPartition(documentOffset - 1).getOffset() : document.getPartition(documentOffset).getOffset();
            String prefix = document.get(start, documentOffset - start);
            prefix = prefix.replace('\n', ' ');
            prefix = prefix.replace('\r', ' ');
            prefix = prefix.replace('\t', ' ');
            StringTokenizer st = new StringTokenizer(prefix, " ");
            String tagname = !st.hasMoreTokens() ? prefix : st.nextToken();
            if (tagname.trim().length() >= 3) {
                if (prefix.trim().substring(0, 3).equals("<b:")) {
                    biltag = true;
                    is_biltag_b = true;
                    is_biltag_s = false;
                    tagnamespace = "b:";
                    tagname = tagname.trim().substring(3);
                    syntax = DictionaryManager.getDictionary("B_DICTIONARY");
                }
                if (prefix.trim().substring(0, 3).equals("<s:")) {
                    biltag = true;
                    is_biltag_s = true;
                    is_biltag_b = false;
                    tagnamespace = "s:";
                    tagname = tagname.trim().substring(3);
                    syntax = DictionaryManager.getDictionary("S_DICTIONARY");
                }
            }
            if (tagname.trim().startsWith("<")) {
                htmltag = true;
                is_biltag_s = false;
                is_biltag_b = false;
                tagname = tagname.trim().substring(1);
                syntax = DictionaryManager.getDictionary("HTML_DICTIONARY");
            }
            if (tagname.endsWith(">")) {
                tagname = tagname.substring(0, tagname.length() - 1);
            }
            while (st.hasMoreTokens()) {
                limiting = st.nextToken();
            }
            if (limiting.indexOf("\"") > 0 || limiting.indexOf("'") > 0) {
                limiting = "";
            }
            if (biltag && limiting.length() <= 0 && !invoker.equals(" ") && !invoker.equals("\t") && !invoker.equals(">")) {
                String taglimiting = prefix.trim().substring(3);
                if (invoker.charAt(0) == '\"' && document.getLength() > documentOffset && document.getChar(documentOffset) == '\"' && document.getChar(documentOffset - 2) != '=') {
                    document.replace(documentOffset, 1, "");
                    return null;
                }
                int indexOfFirstSpace = taglimiting.indexOf(" ");
                if (indexOfFirstSpace != -1) {
                    return this.getAttributeValueProposals(syntax, taglimiting, indexOfFirstSpace, documentOffset);
                }
                return this.makeSetToProposal(syntax.getFilteredElements(taglimiting), documentOffset, (short)0, taglimiting.length());
            }
            if (htmltag && limiting.length() <= 0 && !invoker.equals(" ") && !invoker.equals("\t") && !invoker.equals(">")) {
                String taglimiting = prefix.trim().substring(1);
                if (invoker.charAt(0) == '\"' && document.getChar(documentOffset) == '\"' && document.getChar(documentOffset - 2) != '=') {
                    document.replace(documentOffset, 1, "");
                    return null;
                }
                int indexOfFirstSpace = taglimiting.indexOf(" ");
                if (indexOfFirstSpace != -1) {
                    return this.getAttributeValueProposals(syntax, taglimiting, indexOfFirstSpace, documentOffset);
                }
                return this.makeSetToProposal(syntax.getFilteredElements(taglimiting), documentOffset, (short)0, taglimiting.length());
            }
            if (BILPreferenceManager.autoCloseTag() && invoker.equals(">")) {
                if (syntax != null && syntax.tagExists(tagname)) {
                    Tag tag = syntax.getTag(tagname);
                    String xmlclose = viewer.getDocument().get(documentOffset - 2, 1);
                    if (tag != null && tag.isSingle() && !xmlclose.equals("/")) {
                        IDocument doc = viewer.getDocument();
                        doc.replace(documentOffset - 1, 0, " /");
                    } else if (tag != null && !tag.isSingle() && !xmlclose.equals("/")) {
                        StringBuffer sb = new StringBuffer(20);
                        String fqt = String.valueOf(tagnamespace) + tagname;
                        boolean closed = this.isClosed(fqt, viewer, documentOffset);
                        if (!closed) {
                            sb.append("</" + fqt + ">");
                            String addtag = sb.toString();
                            IDocument doc = viewer.getDocument();
                            String wordb4 = doc.get(documentOffset - fqt.length() - 2, fqt.length() + 1);
                            if (!wordb4.equalsIgnoreCase("/" + fqt)) {
                                doc.replace(documentOffset, 0, addtag);
                            }
                        }
                    }
                }
            } else if (!invoker.equals("~")) {
                limiting = limiting.trim();
                String[] quote_parts = prefix.split("\"");
                if (quote_parts.length % 2 != 0 && syntax != null && prefix.indexOf(62) < 0) {
                    return this.makeSetToProposal(syntax.getFilteredAttributes(tagname.trim(), limiting), documentOffset, (short)1, limiting.length());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"e :: \n", (Throwable)e);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isClosed(String tagName, ITextViewer viewer, int documentOffset) {
        try {
            document = viewer.getDocument();
            linenum = document.getLineOfOffset(documentOffset);
            linestart = document.getLineOffset(linenum);
            len = document.getLineLength(linenum);
            eol = linestart + len;
            lastLinePart = document.get(documentOffset, eol - documentOffset);
            isStartTag = false;
            isClosing = false;
            scanTagName = "";
            i = 0;
            while (i < lastLinePart.length()) {
                block8: {
                    block7: {
                        if (!isStartTag || lastLinePart.charAt(i) != '/') break block7;
                        isClosing = true;
                        break block8;
                    }
                    if (!isClosing) ** GOTO lbl24
                    if (lastLinePart.charAt(i) == '>') {
                        isStartTag = false;
                        if (scanTagName.equals(tagName)) {
                            return true;
                        }
                    } else {
                        scanTagName = String.valueOf(scanTagName) + lastLinePart.charAt(i);
lbl24:
                        // 2 sources

                        if (lastLinePart.charAt(i) == '<') {
                            isStartTag = true;
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            BILCompletionProcessor.LOG.error((Object)"e :: \n", (Throwable)e);
        }
        return false;
    }

    private ICompletionProposal[] makeSetToProposal(Set st, int offset, short type, int currentlen) {
        if (st != null) {
            TreeSet ts = new TreeSet();
            ts.addAll(st);
            Object[] obj = ts.toArray();
            ICompletionProposal[] result = new ICompletionProposal[obj.length];
            boolean endTagAdded = false;
            int i = 0;
            while (i < obj.length) {
                String name = "";
                String display = "";
                String help = "";
                if (obj[i] instanceof Tag) {
                    Tag ptr_tg = (Tag)obj[i];
                    name = ptr_tg.getName();
                    display = ptr_tg.toString();
                    help = ptr_tg.getHelp();
                    if (ptr_tg.isSingle() && ptr_tg.isXMLStyle()) {
                        name = String.valueOf(name) + " />";
                        endTagAdded = true;
                    } else {
                        name = !ptr_tg.isXMLStyle() && !ptr_tg.hasParameters() ? String.valueOf(name) + ">" : String.valueOf(name) + " ";
                    }
                } else if (obj[i] instanceof Parameter) {
                    name = ((Parameter)obj[i]).getName();
                    display = obj[i].toString();
                    help = ((Parameter)obj[i]).getHelp();
                } else if (obj[i] instanceof Value) {
                    name = ((Value)obj[i]).getValue();
                    display = obj[i].toString();
                    help = "";
                    if (name.equals("BROWSE")) {
                        help = "Select BROWSE to browse for a file";
                    }
                } else if (obj[i] instanceof String) {
                    name = obj[i].toString();
                    display = new String(name);
                    help = "";
                }
                name = name.substring(currentlen, name.length());
                int insertlen = 0;
                Image img = null;
                switch (type) {
                    case 1: {
                        name = String.valueOf(name) + "=\"\"";
                        insertlen = name.length() - 1;
                        img = BILPluginImages.get("attribute.gif");
                        break;
                    }
                    case 0: {
                        insertlen = name.length();
                        img = BILPluginImages.get("element.gif");
                        if (is_biltag_s) {
                            img = BILPluginImages.get("element_s.gif");
                            break;
                        }
                        if (!is_biltag_b) break;
                        img = BILPluginImages.get("element_b.gif");
                        break;
                    }
                    case 2: {
                        insertlen = name.length();
                        img = BILPluginImages.get("value.gif");
                    }
                }
                if (endTagAdded) {
                    insertlen -= 2;
                }
                result[i] = new CompletionProposal(name, offset, 0, insertlen, img, display, null, help);
                ++i;
            }
            return result;
        }
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', 'f', ' ', 'F', '~', '\t', '\n', '\r', '>', '\"'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'(', '.', ','};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        boolean insideFunction = false;
        try {
            int linenum = viewer.getDocument().getLineOfOffset(documentOffset);
            int linestart = viewer.getDocument().getLineOffset(linenum);
            String currentline = viewer.getDocument().get(linestart, documentOffset - linestart);
            if (currentline.lastIndexOf("(") > 0 && (currentline.lastIndexOf(")") == -1 || currentline.lastIndexOf(")") < currentline.lastIndexOf("("))) {
                currentline = currentline.substring(0, currentline.lastIndexOf("("));
                insideFunction = true;
            }
            currentline = currentline.replace('\"', ' ');
            currentline = currentline.replace('\'', ' ');
            currentline = currentline.replace('#', ' ');
            currentline = currentline.replace('(', ' ');
            currentline = currentline.replace(')', ' ');
            StringTokenizer st = new StringTokenizer(currentline, " ");
            String functionname = "";
            while (st.hasMoreTokens()) {
                functionname = st.nextToken();
            }
            if (insideFunction) {
                functionname = String.valueOf(functionname) + "(";
            }
            SyntaxDictionary syntax = DictionaryManager.getDictionary("B_DICTIONARY");
            Set fst = syntax.getFunctions();
            if ((fst = SyntaxDictionary.limitSet(fst, functionname.trim())).size() > 0) {
                IContextInformation[] result = new IContextInformation[fst.size() + 1];
                Iterator i = fst.iterator();
                int x = 0;
                while (i.hasNext()) {
                    Function fun = syntax.getFunction((String)i.next());
                    String usage = fun.toString();
                    result[x] = new ContextInformation(BILPluginImages.get("function.gif"), usage, usage);
                    this.validator.install(result[x], viewer, documentOffset);
                    ++x;
                }
                result[x] = new ContextInformation("", "");
                return result;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"BILCompletionProcessor :: computeContextInformation ::>\n", (Throwable)e);
            return null;
        }
    }

    public String getErrorMessage() {
        return null;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected ITextViewer view;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            try {
                String paren = this.view.getDocument().get(offset - 1, 1);
                if (paren.equals(")")) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return false;
            }
            return true;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.view = viewer;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return true;
        }
    }
}

