/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.preferences;

import com.backbase.bxmleditor.BILPlugin;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.RGB;

public class BILPreferenceManager {
    private static final Logger LOG;
    private static IPreferenceStore store;
    private static int default_tab_width;
    private static int default_insight_delay;
    private static boolean insert_tabs_spaces;
    private static boolean auto_close_tags;
    private static RGB defaultTagColor;
    private static RGB defaultBTagColor;
    private static RGB defaultSTagColor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.preferences.BILPreferenceManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        store = null;
        default_tab_width = 4;
        default_insight_delay = 300;
        insert_tabs_spaces = false;
        auto_close_tags = true;
        defaultTagColor = new RGB(0, 0, 128);
        defaultBTagColor = new RGB(0, 0, 255);
        defaultSTagColor = new RGB(255, 0, 0);
    }

    public BILPreferenceManager() {
        store = BILPlugin.getDefault().getPreferenceStore();
    }

    public void initializeDefaultValues() {
        if (store == null) {
            store = BILPlugin.getDefault().getPreferenceStore();
        }
        store.setDefault("tagColorPreference", "0,0,128");
        store.setDefault("insightDelay", default_insight_delay);
        store.setDefault("tabWidth", default_tab_width);
        store.setDefault("tabsAsSpaces", insert_tabs_spaces);
        store.setDefault("autoCloseTags", auto_close_tags);
        store.setDefault("snippetPath", BILPlugin.getDefault().getStateLocation().toString());
    }

    public int tabWidth() {
        return Integer.parseInt(store.getString("tabWidth").trim());
    }

    public static RGB tagColor() {
        String[] color = store.getString("tagColorPreference").trim().split(",");
        if (color.length < 3) {
            return defaultTagColor;
        }
        return new RGB(Integer.parseInt(color[0].trim()), Integer.parseInt(color[1].trim()), Integer.parseInt(color[2].trim()));
    }

    public static RGB tagBColor() {
        String[] color = store.getString("BtagColorPreference").trim().split(",");
        if (color.length < 3) {
            return defaultBTagColor;
        }
        return new RGB(Integer.parseInt(color[0].trim()), Integer.parseInt(color[1].trim()), Integer.parseInt(color[2].trim()));
    }

    public static RGB tagSColor() {
        String[] color = store.getString("StagColorPreference").trim().split(",");
        if (color.length < 3) {
            return defaultSTagColor;
        }
        return new RGB(Integer.parseInt(color[0].trim()), Integer.parseInt(color[1].trim()), Integer.parseInt(color[2].trim()));
    }

    public static int defaultTabWidth() {
        return default_tab_width;
    }

    public static void setAutoCloseTags(boolean auto_close_tags) {
        BILPreferenceManager.auto_close_tags = auto_close_tags;
    }

    public boolean autoCloseTags() {
        return store.getString("autoCloseTags").trim().equalsIgnoreCase("true");
    }

    public boolean insertSpacesForTabs() {
        return store.getString("tabsAsSpaces").trim().equalsIgnoreCase("true");
    }

    public static boolean autoCloseTag() {
        return store.getString("autoCloseTags").trim().equalsIgnoreCase("true");
    }

    public static boolean defaultSpacesForTabs() {
        return insert_tabs_spaces;
    }

    public int insightDelay() {
        return Integer.parseInt(store.getString("insightDelay").trim());
    }

    public static int defaultInsightDelay() {
        return default_insight_delay;
    }

    public String snippetsPath() {
        return store.getString("snippetPath").trim();
    }

    public static boolean isAuto_close_tags() {
        return auto_close_tags;
    }

    public String defaultSnippetsPath() {
        return BILPlugin.getDefault().getStateLocation().toString();
    }

    public String projectURL() {
        return "http://www.backbase.com";
    }

    public static RGB defaultTagColor() {
        return defaultTagColor;
    }

    public static RGB defaultBTagColor() {
        return defaultBTagColor;
    }

    public static RGB defaultSTagColor() {
        return defaultSTagColor;
    }
}

