/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.views.contentoutline;

import com.backbase.bxmleditor.BILPluginImages;
import com.backbase.bxmleditor.editors.BILEditor;
import com.backbase.bxmleditor.editors.IBILDocument;
import com.backbase.bxmleditor.parser.BILDocument;
import com.backbase.bxmleditor.parser.BILNodeList;
import com.backbase.bxmleditor.parser.DocItem;
import com.backbase.bxmleditor.parser.TagItem;
import com.backbase.bxmleditor.views.contentoutline.OutlineContentProvider;
import com.backbase.bxmleditor.views.contentoutline.OutlineLabelProvider;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class BILContentOutlineView
extends ContentOutlinePage
implements IPartListener,
IPropertyListener {
    public static final String ID_CONTENTOUTLINE = "com.backbase.bxmleditor.views.contentoutline";
    protected LabelProvider labelProvider;
    protected Action jumpAction;
    protected Action expandAction;
    protected Action[] filters;
    protected MenuManager menuMgr;
    private boolean menusmade = false;
    private boolean treemade = false;
    private static String filter = "";
    private ArrayList lastExpandedElements = null;
    private OutlineContentProvider cop;

    public Control getControl() {
        if (!this.treemade) {
            this.getTreeViewer().setUseHashlookup(true);
            this.lastExpandedElements = new ArrayList();
            this.saveExpandedElements();
            this.createTree();
            this.treemade = true;
        }
        if (!this.menusmade) {
            this.createActions();
            this.createMenus();
            this.createToolbar();
            this.createContextMenu();
            this.menusmade = true;
        }
        return this.getTreeViewer().getControl();
    }

    private void saveExpandedElements() {
        Object[] ob = this.getTreeViewer().getExpandedElements();
        int oblen = ob.length;
        int i = 0;
        while (i < oblen) {
            this.lastExpandedElements.clear();
            this.lastExpandedElements.add(ob[i]);
            ++i;
        }
    }

    protected void createTree() {
        if (filter.length() == 0) {
            this.reload();
        } else {
            this.reload(this.getItems(filter));
        }
    }

    public DocItem getItems(String filter) {
        TagItem scratch = new TagItem(1, 1, 1, "root");
        DocItem rootItem = this.getRootInput();
        BILNodeList nodes = rootItem.selectNodes(filter);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
        }
        return scratch;
    }

    public DocItem getRootInput() {
        try {
            DocItem docRoot = null;
            IEditorPart iep = this.getSite().getPage().getActiveEditor();
            iep.addPropertyListener((IPropertyListener)this);
            this.getSite().getPage().addPartListener((IPartListener)this);
            ITextEditor ite = (ITextEditor)iep;
            IBILDocument icfd = (IBILDocument)ite.getDocumentProvider().getDocument((Object)iep.getEditorInput());
            icfd.clearAllMarkers();
            icfd.parseDocument();
            BILDocument cfd = icfd.getCFDocument();
            if (cfd != null) {
                docRoot = cfd.getDocumentRoot();
            }
            if (docRoot != null) {
                return docRoot;
            }
            return new TagItem(1, 1, 1, "Unk");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return new TagItem(1, 1, 1, "Unk");
        }
    }

    protected void jumpToItem() {
        IEditorPart iep = this.getSite().getPage().getActiveEditor();
        DocItem selecteditem = null;
        if (this.getTreeViewer().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        selecteditem = (DocItem)selection.getFirstElement();
        if (selecteditem == null) {
            return;
        }
        try {
            ITextEditor editor = (ITextEditor)iep;
            editor.setHighlightRange(selecteditem.getStartPosition(), 0, true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void reload(DocItem root) {
        if (this.cop == null) {
            this.cop = new OutlineContentProvider(root);
            this.getTreeViewer().setContentProvider((IContentProvider)this.cop);
        }
        if (this.labelProvider == null) {
            this.labelProvider = new OutlineLabelProvider();
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.getTreeViewer().setInput((Object)root);
    }

    public void reload() {
        if (filter.length() == 0) {
            DocItem di = this.getRootInput();
            this.reload(di);
        } else {
            this.reload(this.getItems(filter));
        }
    }

    public void expand() {
        this.getTreeViewer().expandAll();
    }

    protected void createActions() {
        this.jumpAction = new Action("Jump", BILPluginImages.getImageRegistry().getDescriptor("show.gif")){

            public void run() {
                BILContentOutlineView.this.jumpToItem();
            }
        };
        this.expandAction = new Action("Expand All", BILPluginImages.getImageRegistry().getDescriptor("add.gif")){

            public void run() {
                BILContentOutlineView.this.getTreeViewer().expandAll();
            }
        };
        this.filters = new Action[6];
        this.filters[0] = new Action("None", BILPluginImages.getImageRegistry().getDescriptor("delete.gif")){

            public void run() {
                filter = "";
                BILContentOutlineView.this.reload();
            }
        };
        this.filters[1] = new Action("Include", BILPluginImages.getImageRegistry().getDescriptor("element.gif")){

            public void run() {
                filter = "//include";
                BILContentOutlineView.this.reload(BILContentOutlineView.this.getItems(filter));
            }
        };
        this.filters[2] = new Action("Module", BILPluginImages.getImageRegistry().getDescriptor("element.gif")){

            public void run() {
                filter = "//module";
                BILContentOutlineView.this.reload(BILContentOutlineView.this.getItems(filter));
            }
        };
        this.filters[3] = new Action("Query", BILPluginImages.getImageRegistry().getDescriptor("element.gif")){

            public void run() {
                filter = "//query";
                BILContentOutlineView.this.reload(BILContentOutlineView.this.getItems(filter));
            }
        };
        this.filters[4] = new Action("Set", BILPluginImages.getImageRegistry().getDescriptor("element.gif")){

            public void run() {
                filter = "//set";
                BILContentOutlineView.this.reload(BILContentOutlineView.this.getItems(filter));
            }
        };
        this.filters[5] = new Action("Custom", BILPluginImages.getImageRegistry().getDescriptor("element.gif")){

            public void run() {
                String xpath;
                InputDialog pathdialog = new InputDialog(BILContentOutlineView.this.getSite().getShell(), "CFML Path Filter", "Filter outline using path (i.e. \"//output\" for all the cfoutput tags):", "", null);
                if (pathdialog.open() == 0 && (xpath = pathdialog.getValue()).length() > 0) {
                    filter = xpath;
                    BILContentOutlineView.this.reload(BILContentOutlineView.this.getItems(filter));
                }
            }
        };
    }

    public void partActivated(IWorkbenchPart part) {
        boolean cfr_ignored_0 = part instanceof BILEditor;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        System.out.println("Part opened: " + part.getClass().getName());
        boolean cfr_ignored_0 = part instanceof BILEditor;
    }

    public void propertyChanged(Object source, int propId) {
        System.out.println("Property changed: " + source.getClass().getName());
        if (source instanceof BILEditor) {
            DocItem old = (DocItem)this.getTreeViewer().getInput();
            this.reload();
            this.cop.inputChanged((Viewer)this.getTreeViewer(), old, this.getTreeViewer().getInput());
        }
    }

    protected void createMenus() {
        IMenuManager rootMenuManager = super.getSite().getActionBars().getMenuManager();
        int flen = this.filters.length;
        int i = 0;
        while (i < flen) {
            rootMenuManager.add((IAction)this.filters[i]);
            ++i;
        }
    }

    private void createContextMenu() {
        this.menuMgr = new MenuManager();
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                BILContentOutlineView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.jumpAction);
    }

    protected void createToolbar() {
        IToolBarManager toolbarManager = super.getSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.jumpAction);
    }
}

