/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.dictionary;

import com.backbase.bxmleditor.dictionary.Value;
import java.util.HashSet;
import java.util.Set;

public class Parameter
implements Comparable {
    protected String name = "";
    protected String type = "void";
    protected String help = "";
    protected Set values;
    protected boolean required;

    public Parameter(String name) {
        this.name = name;
    }

    public Parameter(String name, String type) {
        this(name);
        this.type = type;
    }

    public Parameter(String name, String type, boolean required) {
        this(name, type);
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setNameAndType(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public void addValue(Value value) {
        if (this.values == null) {
            this.values = new HashSet();
        }
        this.values.add(value);
    }

    public Set getValues() {
        if (this.values == null) {
            return new HashSet();
        }
        return this.values;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + " ");
        sb.append("[" + this.type + "]");
        if (this.required) {
            sb.append("*");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof Parameter && ((Parameter)obj).getName().equals(this.name) && ((Parameter)obj).getType().equals(this.type);
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("Null!");
        }
        if (o instanceof Parameter) {
            return this.name.compareTo(((Parameter)o).getName());
        }
        return 0;
    }
}

