/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.dictionary;

import com.backbase.bxmleditor.dictionary.Parameter;
import java.util.HashSet;
import java.util.Set;

public class Procedure
implements Comparable {
    public static final String STRING = "string";
    public static final String NUMERIC = "numeric";
    public static final String OBJECT = "object";
    public static final String VOID = "void";
    public static final String STRUCT = "struct";
    public static final String QUERY = "query";
    public static final byte MX = 1;
    public static final byte BD = 2;
    public static final byte W3C = 4;
    public static final byte USR = 8;
    protected String name = "";
    protected byte creator = 1;
    protected String help = "";
    protected Set parameters = null;

    public Procedure(String name) {
        this.name = name;
    }

    public byte getCreatorFlags() {
        return this.creator;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() >= 1;
    }

    public void addParameter(Parameter param) {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        this.parameters.add(param);
    }

    public void dumpParams() {
        Object[] params = this.parameters.toArray();
        int i = 0;
        while (i < params.length) {
            ++i;
        }
    }

    public Set getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getHelp() {
        return this.help;
    }

    public String toString() {
        if (this.parameters != null) {
            return String.valueOf(this.name) + ":" + this.parameters.size();
        }
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof Procedure && ((Procedure)obj).getName().equals(this.name) && ((Procedure)obj).getParameters().size() == this.parameters.size();
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("Null!");
        }
        if (o instanceof Procedure) {
            return this.name.compareTo(((Procedure)o).getName());
        }
        return 0;
    }
}

