/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.dictionary;

import com.backbase.bxmleditor.BILPlugin;
import com.backbase.bxmleditor.dictionary.DictionaryContentHandler;
import com.backbase.bxmleditor.dictionary.Function;
import com.backbase.bxmleditor.dictionary.Parameter;
import com.backbase.bxmleditor.dictionary.Procedure;
import com.backbase.bxmleditor.dictionary.Tag;
import com.backbase.bxmleditor.dictionary.Value;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class SyntaxDictionary {
    private static final Logger LOG;
    protected Map syntaxelements = new HashMap();
    protected Map functions = new HashMap();
    protected String filename = null;
    protected static URL dictionaryBaseURL;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.dictionary.SyntaxDictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        if (dictionaryBaseURL == null) {
            try {
                dictionaryBaseURL = new URL(BILPlugin.getDefault().getBundle().getEntry("/"), "data/");
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"e :: ", (Throwable)e);
            }
        }
    }

    public void loadDictionary(String filename) {
        this.setFilename(filename);
        try {
            this.loadDictionary();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setFilename(String fname) {
        this.filename = fname;
    }

    public Set getAllElements() {
        return this.syntaxelements.keySet();
    }

    public Set getAllTags() {
        HashSet total = new HashSet();
        Set keys = this.getAllElements();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            total.add(this.syntaxelements.get(it.next()));
        }
        return total;
    }

    public Set getAllFunctions() {
        HashSet total = new HashSet();
        Set keys = this.getFunctions();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            total.add(this.functions.get(it.next()));
        }
        return total;
    }

    public Set getFilteredElements(String start) {
        return SyntaxDictionary.limitSet(this.getAllTags(), start);
    }

    public Tag getTag(String name) {
        Object obj = this.syntaxelements.get(name.toLowerCase());
        if (obj != null) {
            return (Tag)obj;
        }
        return null;
    }

    public Set getFilteredAttributeValues(String tag, String attribute, String start) {
        Set attribs = this.getElementAttributes(tag);
        if (attribs.size() == 0) {
            return null;
        }
        Object[] tempArray = attribs.toArray();
        int i = 0;
        while (i < tempArray.length) {
            Parameter currParam = (Parameter)tempArray[i];
            if (currParam.getName().compareTo(attribute) == 0) {
                return SyntaxDictionary.limitSet(currParam.getValues(), start);
            }
            ++i;
        }
        return null;
    }

    public Set getFilteredAttributes(String tag, String start) {
        return SyntaxDictionary.limitSet(this.getElementAttributes(tag), start);
    }

    public Set getFunctions() {
        return this.functions.keySet();
    }

    public String getFunctionUsage(String functionname) {
        return (String)this.functions.get(functionname.toLowerCase());
    }

    public Function getFunction(String name) {
        Object obj = this.functions.get(name.toLowerCase());
        if (obj != null) {
            return (Function)obj;
        }
        return null;
    }

    public boolean tagExists(String name) {
        if (this.syntaxelements == null) {
            return false;
        }
        return this.syntaxelements.containsKey(name.toLowerCase());
    }

    public boolean functionExists(String name) {
        if (this.functions == null) {
            return false;
        }
        return this.functions.containsKey(name.toLowerCase());
    }

    public static Set limitSet(Set st, String start) {
        HashSet filterset = new HashSet();
        Set fullset = st;
        if (fullset != null) {
            Iterator it = fullset.iterator();
            while (it.hasNext()) {
                String possible;
                Object item = it.next();
                if (item instanceof String) {
                    possible = (String)item;
                } else if (item instanceof Tag) {
                    possible = ((Tag)item).getName();
                } else if (item instanceof Function) {
                    possible = ((Function)item).getName();
                } else if (item instanceof Parameter) {
                    possible = ((Parameter)item).getName();
                } else if (item instanceof Value) {
                    possible = ((Value)item).getValue();
                } else {
                    throw new IllegalArgumentException("The passed set must have only Strings, Procedures, or Parameters");
                }
                if (start.endsWith("(") && possible.equalsIgnoreCase(start.substring(0, start.length() - 1))) {
                    filterset.add(item);
                    continue;
                }
                if (!possible.toUpperCase().startsWith(start.toUpperCase())) continue;
                filterset.add(item);
            }
        }
        return filterset;
    }

    public Set getElementAttributes(String elementname) {
        Procedure p = (Procedure)this.syntaxelements.get(elementname.toLowerCase());
        if (p != null) {
            Set st = p.getParameters();
            return st;
        }
        return null;
    }

    private void loadDictionary() throws IOException, SAXException, ParserConfigurationException {
        if (this.filename == null) {
            throw new IOException("Filename can not be null!");
        }
        URLConnection urlcon = new URL(dictionaryBaseURL + "/" + this.filename).openConnection();
        BufferedInputStream xml = new BufferedInputStream(urlcon.getInputStream());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        xmlReader.setContentHandler(new DictionaryContentHandler(this.syntaxelements, this.functions));
        InputSource input = new InputSource(xml);
        xmlReader.parse(input);
    }
}

