/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.editors;

import com.backbase.bxmleditor.BILPlugin;
import com.backbase.bxmleditor.dictionary.DictionaryManager;
import com.backbase.bxmleditor.editors.BILAutoIndentStrategy;
import com.backbase.bxmleditor.editors.BILCompletionProcessor;
import com.backbase.bxmleditor.editors.BILDoubleClickStrategy;
import com.backbase.bxmleditor.editors.BILEditor;
import com.backbase.bxmleditor.editors.BILTextHover;
import com.backbase.bxmleditor.editors.NonRuleBasedDamagerRepairer;
import com.backbase.bxmleditor.editors.colors.ColorConstants;
import com.backbase.bxmleditor.editors.colors.ColorManager;
import com.backbase.bxmleditor.editors.scanners.BTagScanner;
import com.backbase.bxmleditor.editors.scanners.HTMLTagScanner;
import com.backbase.bxmleditor.editors.scanners.STagScanner;
import com.backbase.bxmleditor.editors.scanners.ScriptScanner;
import com.backbase.bxmleditor.editors.scanners.StyleScanner;
import com.backbase.bxmleditor.editors.scanners.TextScanner;
import com.backbase.bxmleditor.editors.script.JSCompletionProcessor;
import com.backbase.bxmleditor.preferences.BILPreferenceManager;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class BILConfiguration
extends SourceViewerConfiguration
implements IPropertyChangeListener {
    private static final Logger LOG;
    private BILDoubleClickStrategy doubleClickStrategy;
    private HTMLTagScanner htmtagScanner;
    private BTagScanner bTagScanner;
    private STagScanner sTagScanner;
    private HTMLTagScanner unktagScanner;
    private TextScanner scanner;
    private StyleScanner stylescanner;
    private ScriptScanner scriptscanner;
    private ColorManager colorManager;
    private ContentAssistant assistant;
    private BILAutoIndentStrategy indentStrategy;
    private BILPreferenceManager preferenceManager;
    private int tabWidth;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.editors.BILConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public BILConfiguration(ColorManager colorManager, BILEditor editor) {
        this.colorManager = colorManager;
        this.preferenceManager = new BILPreferenceManager();
        this.indentStrategy = new BILAutoIndentStrategy(editor);
        this.tabWidth = this.preferenceManager.tabWidth();
        boolean insertSpacesForTabs = this.preferenceManager.insertSpacesForTabs();
        this.indentStrategy.setIndentString(this.tabWidth, insertSpacesForTabs);
        BILPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.tabWidth;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__html_comment", "__css_tag", "__b_tag", "__s_tag", "__all_tag", "__unknow_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new BILDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected TextScanner getTextScanner() {
        if (this.scanner == null) {
            this.scanner = new TextScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected HTMLTagScanner getHTMLTagScanner() {
        if (this.htmtagScanner == null) {
            this.htmtagScanner = new HTMLTagScanner(this.colorManager);
            this.htmtagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.TAG))));
        }
        return this.htmtagScanner;
    }

    protected BTagScanner getBTagScanner() {
        if (this.bTagScanner == null) {
            this.bTagScanner = new BTagScanner(this.colorManager);
            this.bTagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.TAG_B))));
        }
        return this.bTagScanner;
    }

    protected STagScanner getSTagScanner() {
        if (this.sTagScanner == null) {
            this.sTagScanner = new STagScanner(this.colorManager);
            this.sTagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.TAG_S))));
        }
        return this.sTagScanner;
    }

    protected HTMLTagScanner getUNKTagScanner() {
        if (this.unktagScanner == null) {
            this.unktagScanner = new HTMLTagScanner(this.colorManager);
            this.unktagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.UNKNOW_TAG))));
        }
        return this.unktagScanner;
    }

    protected StyleScanner getStyleScanner() {
        if (this.stylescanner == null) {
            this.stylescanner = new StyleScanner(this.colorManager);
            this.stylescanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.CSS))));
        }
        return this.stylescanner;
    }

    protected ScriptScanner getScriptScanner() {
        if (this.scriptscanner == null) {
            this.scriptscanner = new ScriptScanner(this.colorManager);
            this.scriptscanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorConstants.DEFAULT))));
        }
        return this.scriptscanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getBTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__b_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__b_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__s_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__s_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getHTMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__all_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__all_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__script_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__script_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStyleScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__css_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__css_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getUNKTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__unknow_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__unknow_tag");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(ColorConstants.HTML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__html_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__html_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.assistant = new ContentAssistant();
        BILCompletionProcessor cfcp = new BILCompletionProcessor(this.assistant);
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)cfcp, "__dftl_partition_content_type");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)cfcp, "__b_tag");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)cfcp, "__s_tag");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)cfcp, "__all_tag");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)cfcp, "__unknow_tag");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)cfcp, "__css_tag");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)new JSCompletionProcessor(), "__script_tag");
        int delay = this.preferenceManager.insightDelay();
        this.assistant.enableAutoActivation(true);
        this.assistant.setAutoActivationDelay(delay);
        this.assistant.setProposalPopupOrientation(10);
        this.assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return this.assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "__all_tag") {
            return new BILTextHover(DictionaryManager.getDictionary("HTML_DICTIONARY"));
        }
        if (contentType == "__b_tag") {
            return new BILTextHover(DictionaryManager.getDictionary("B_DICTIONARY"));
        }
        if (contentType == "__s_tag") {
            return new BILTextHover(DictionaryManager.getDictionary("S_DICTIONARY"));
        }
        if (contentType != "__html_comment") {
            return new BILTextHover(DictionaryManager.getDictionary("B_DICTIONARY"));
        }
        return null;
    }

    public IAutoEditStrategy getAutoEditStrategy(ISourceViewer arg0, String arg1) {
        return this.indentStrategy;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("tagColorPreference") || event.getProperty().equals("StagColorPreference") || event.getProperty().equals("BtagColorPreference")) {
            LOG.info((Object)" Color changed..resetting: ");
            this.htmtagScanner = null;
            this.bTagScanner = null;
            this.sTagScanner = null;
        }
        if (event.getProperty().equals("insightDelay")) {
            int delay = this.preferenceManager.insightDelay();
            this.assistant.enableAutoActivation(true);
            this.assistant.setAutoActivationDelay(delay);
        } else if (event.getProperty().equals("tabsAsSpaces") || event.getProperty().equals("tabWidth")) {
            this.tabWidth = this.preferenceManager.tabWidth();
            boolean tabsAsSpaces = this.preferenceManager.insertSpacesForTabs();
            this.indentStrategy.setIndentString(this.tabWidth, tabsAsSpaces);
        }
    }
}

