/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.parser;

import com.backbase.bxmleditor.parser.ParseError;
import com.backbase.bxmleditor.parser.ParseMessage;
import com.backbase.bxmleditor.parser.TagItem;
import com.backbase.bxmleditor.parser.TagMatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class State {
    protected ArrayList messages = new ArrayList();
    protected String filename;
    protected int errCount = 0;
    protected boolean hadFatal = false;
    protected ArrayList matches = new ArrayList();
    protected HashMap functionNames = new HashMap();
    protected HashMap variableNames = new HashMap();
    public static final int ADD_BEFORE = 1;
    public static final int ADD_AFTER = 2;

    public void addFunction(TagItem newFunction) {
        String funcName = newFunction.getAttribute("name");
        if (this.functionNames.containsKey(funcName)) {
            this.addMessage(new ParseError(newFunction.lineNumber, newFunction.startPosition, newFunction.endPosition, newFunction.getItemData(), "Duplicate function '" + funcName + "' found."));
        } else {
            this.functionNames.put(funcName, funcName);
        }
    }

    public ArrayList getMatches() {
        return this.matches;
    }

    public State(String docFilename) {
        this.filename = docFilename;
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    public void addMatch(TagMatch newMatch, int position, int numIndicies) {
        switch (position) {
            case 1: {
                this.matches.add(this.matches.size() - numIndicies, newMatch);
                break;
            }
            case 2: {
                this.addMatch(newMatch);
                break;
            }
        }
    }

    public void addMatch(TagMatch newMatch) {
        this.matches.add(newMatch);
    }

    public boolean hadFatal() {
        return this.hadFatal;
    }

    public void addMessage(ParseMessage newMsg) {
        if (newMsg instanceof ParseError) {
            if (((ParseError)newMsg).isFatal()) {
                this.hadFatal = true;
            }
            ++this.errCount;
        }
        this.messages.add(newMsg);
    }

    public void addMessages(ArrayList newMessages) {
        Iterator msgIter = newMessages.iterator();
        ParseMessage currMsg = null;
        while (msgIter.hasNext()) {
            currMsg = (ParseMessage)msgIter.next();
            if (currMsg instanceof ParseError) {
                if (((ParseError)currMsg).isFatal()) {
                    this.hadFatal = true;
                }
                ++this.errCount;
            }
            this.messages.add(currMsg);
        }
    }
}

