/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.preferences;

import com.backbase.bxmleditor.BILPlugin;
import com.backbase.bxmleditor.preferences.BILPreferenceManager;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BILPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text insightDelayField;
    Text tabWidthField;
    ColorFieldEditor tagColorField;
    ColorFieldEditor BtagColorField;
    ColorFieldEditor StagColorField;
    Button tabsAsSpacesCheckBox;
    Button autoCloseTagCheckBox;
    BILPreferenceManager preferenceManager;

    public BILPreferencePage() {
        this.setPreferenceStore(BILPlugin.getDefault().getPreferenceStore());
        this.setDescription("BXML preferences");
        this.preferenceManager = new BILPreferenceManager();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    private Composite createContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createContainer(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Composite defPanel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        defPanel.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        defPanel.setLayoutData((Object)gridData);
        Label label = new Label(defPanel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText("Editor");
        this.createTabsAndSpacesGroup(defPanel);
        this.createInsightGroup(defPanel);
        this.createTagColorsGroup(defPanel);
        return composite;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    private void createInsightGroup(Composite parent) {
        Group insightGroup = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        insightGroup.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        insightGroup.setLayoutData((Object)gridData);
        insightGroup.setText("Tag and function insight");
        this.insightDelayField = this.createLabeledInt("Insight Delay (ms)", this.preferenceManager.insightDelay(), (Composite)insightGroup);
        this.insightDelayField.setTextLimit(5);
        this.insightDelayField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String number = ((Text)e.widget).getText();
                number = number == null ? number : number.trim();
                try {
                    int value = Integer.parseInt(number);
                    if (value <= 0) {
                        BILPreferencePage.this.setValid(false);
                        BILPreferencePage.this.setErrorMessage("The insight delay must be an integer greater than zero");
                    } else {
                        BILPreferencePage.this.setValid(true);
                        BILPreferencePage.this.setErrorMessage(null);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    BILPreferencePage.this.setValid(false);
                    BILPreferencePage.this.setErrorMessage("The insight delay must be an integer greater than zero");
                }
            }
        });
        this.autoCloseTagCheckBox = this.createLabeledCheck("Auto close tags", this.preferenceManager.autoCloseTags(), (Composite)insightGroup);
    }

    private void createTabsAndSpacesGroup(Composite parent) {
        Group tabsComposite = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        tabsComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        tabsComposite.setLayoutData((Object)gridData);
        tabsComposite.setText("Tabs and spaces");
        this.tabWidthField = this.createLabeledInt("Tab width (characters)", this.preferenceManager.tabWidth(), (Composite)tabsComposite);
        this.tabWidthField.setTextLimit(3);
        this.tabWidthField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String number = ((Text)e.widget).getText();
                number = number == null ? number : number.trim();
                try {
                    int value = Integer.parseInt(number);
                    if (value <= 0) {
                        BILPreferencePage.this.setValid(false);
                        BILPreferencePage.this.setErrorMessage("The tab width must be an integer");
                    } else {
                        BILPreferencePage.this.setValid(true);
                        BILPreferencePage.this.setErrorMessage(null);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    BILPreferencePage.this.setValid(false);
                    BILPreferencePage.this.setErrorMessage("The tab width must be an integer");
                }
            }
        });
        this.tabsAsSpacesCheckBox = this.createLabeledCheck("Insert spaces instead of tabs", this.preferenceManager.insertSpacesForTabs(), (Composite)tabsComposite);
    }

    private void createTagColorsGroup(Composite parent) {
        Group tagColorsComposite = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        tagColorsComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        tagColorsComposite.setLayoutData((Object)gridData);
        tagColorsComposite.setText("Tag colors (needs IDE restart)");
        this.tagColorField = new ColorFieldEditor("tagColorPreference", "Tag color", (Composite)tagColorsComposite);
        this.tagColorField.getColorSelector().setColorValue(BILPreferenceManager.tagColor());
        this.BtagColorField = new ColorFieldEditor("BtagColorPreference", "B Tag color", (Composite)tagColorsComposite);
        this.BtagColorField.getColorSelector().setColorValue(BILPreferenceManager.tagBColor());
        this.StagColorField = new ColorFieldEditor("StagColorPreference", "S Tag color", (Composite)tagColorsComposite);
        this.StagColorField.getColorSelector().setColorValue(BILPreferenceManager.tagSColor());
    }

    private Text createLabeledInt(String labelText, int value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(labelText);
        Text fText = new Text(defPanel, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        fText.setLayoutData((Object)gridData);
        fText.setText(Integer.toString(value));
        fText.setToolTipText(labelText);
        return fText;
    }

    private Button createLabeledCheck(String labelText, boolean value, Composite defPanel) {
        Label label = new Label(defPanel, 64);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(labelText);
        Button fButton = new Button(defPanel, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        fButton.setLayoutData((Object)gridData);
        fButton.setSelection(value);
        fButton.setToolTipText(labelText);
        return fButton;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.insightDelayField.setText(Integer.toString(BILPreferenceManager.defaultInsightDelay()));
        this.tabWidthField.setText(Integer.toString(BILPreferenceManager.defaultTabWidth()));
        this.tabsAsSpacesCheckBox.setSelection(BILPreferenceManager.defaultSpacesForTabs());
        this.autoCloseTagCheckBox.setSelection(BILPreferenceManager.isAuto_close_tags());
        this.tagColorField.getColorSelector().setColorValue(BILPreferenceManager.defaultTagColor());
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("insightDelay", this.insightDelayField.getText());
        store.setValue("tabWidth", this.tabWidthField.getText());
        store.setValue("tabsAsSpaces", String.valueOf(this.tabsAsSpacesCheckBox.getSelection()));
        store.setValue("autoCloseTags", String.valueOf(this.autoCloseTagCheckBox.getSelection()));
        store.setValue("tagColorPreference", this.RGBtoSTring(this.tagColorField.getColorSelector().getColorValue()));
        return true;
    }

    private String RGBtoSTring(RGB color) {
        return String.valueOf(color.red) + "," + color.green + "," + color.blue;
    }

    public void init(IWorkbench workbench) {
    }
}

