/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.views.browser;

import com.backbase.bxmleditor.BILPlugin;
import com.backbase.bxmleditor.BILPluginImages;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class BILBrowser {
    private static final Logger LOG;
    protected int index;
    protected boolean busy;
    protected Text location;
    protected Browser browser;
    private ViewPart viewer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.backbase.bxmleditor.views.browser.BILBrowser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public BILBrowser(Composite parent, ViewPart viewer) {
        LOG.info((Object)"BilBrowser instantiated ");
        this.viewer = viewer;
        final Display display = parent.getDisplay();
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        ToolBar toolbar = new ToolBar(parent, 0);
        final ToolItem itemBack = new ToolItem(toolbar, 8);
        itemBack.setImage(BILPluginImages.get("back.gif"));
        itemBack.setToolTipText(BILBrowser.getResourceString("Back"));
        final ToolItem itemForward = new ToolItem(toolbar, 8);
        itemForward.setImage(BILPluginImages.get("forward.gif"));
        itemForward.setToolTipText(BILBrowser.getResourceString("Forward"));
        final ToolItem itemStop = new ToolItem(toolbar, 8);
        itemStop.setImage(BILPluginImages.get("stop.gif"));
        itemStop.setToolTipText(BILBrowser.getResourceString("Stop"));
        final ToolItem itemRefresh = new ToolItem(toolbar, 8);
        itemRefresh.setImage(BILPluginImages.get("refresh.gif"));
        itemRefresh.setToolTipText(BILBrowser.getResourceString("Refresh"));
        final ToolItem itemHome = new ToolItem(toolbar, 8);
        itemHome.setImage(BILPluginImages.get("home.gif"));
        itemHome.setToolTipText(BILBrowser.getResourceString("Go to project homepage"));
        final ToolItem itemGo = new ToolItem(toolbar, 8);
        itemGo.setImage(BILPluginImages.get("process.gif"));
        itemGo.setToolTipText(BILBrowser.getResourceString("Go"));
        this.location = new Text(parent, 2048);
        final Canvas canvas = new Canvas(parent, 2);
        display.asyncExec(new Runnable(){

            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                display.timerExec(150, (Runnable)this);
            }
        });
        final Label status = new Label(parent, 0);
        final ProgressBar progressBar = new ProgressBar(parent, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        toolbar.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)canvas, 5, -1);
        data.bottom = new FormAttachment((Control)status, -5, -1);
        try {
            this.browser = new Browser(parent, 0);
            this.browser.setLayoutData((Object)data);
        }
        catch (SWTError e) {
            Label label = new Label(parent, 0x1000040);
            label.setText(BILBrowser.getResourceString("Browser Not Created (" + e.toString() + ")"));
            label.setLayoutData((Object)data);
        }
        data = new FormData();
        data.width = 24;
        data.height = 24;
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        canvas.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)toolbar, 0, 128);
        data.left = new FormAttachment((Control)toolbar, 5, 131072);
        data.right = new FormAttachment((Control)canvas, -5, -1);
        this.location.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)progressBar, 0, -1);
        data.bottom = new FormAttachment(100, -5);
        status.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        progressBar.setLayoutData((Object)data);
        if (this.browser != null) {
            itemBack.setEnabled(this.browser.isBackEnabled());
            itemForward.setEnabled(this.browser.isForwardEnabled());
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    ToolItem item = (ToolItem)event.widget;
                    if (item == itemBack) {
                        BILBrowser.this.browser.back();
                    } else if (item == itemForward) {
                        BILBrowser.this.browser.forward();
                    } else if (item == itemStop) {
                        BILBrowser.this.browser.stop();
                    } else if (item == itemRefresh) {
                        BILBrowser.this.browser.refresh();
                    } else if (item == itemGo) {
                        BILBrowser.this.browser.setUrl(BILBrowser.this.location.getText());
                    } else if (item == itemHome) {
                        BILBrowser.this.browser.setUrl(BILBrowser.this.getProjectURL());
                    }
                }
            };
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    BILBrowser.this.busy = true;
                    if (event.top) {
                        BILBrowser.this.location.setText(event.location);
                    }
                }

                public void changing(LocationEvent event) {
                }
            });
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    progressBar.setSelection(ratio);
                    boolean bl = BILBrowser.this.busy = event.current != event.total;
                    if (!BILBrowser.this.busy) {
                        BILBrowser.this.index = 0;
                        canvas.redraw();
                    }
                }

                public void completed(ProgressEvent event) {
                    itemBack.setEnabled(BILBrowser.this.browser.isBackEnabled());
                    itemForward.setEnabled(BILBrowser.this.browser.isForwardEnabled());
                    progressBar.setSelection(0);
                    BILBrowser.this.busy = false;
                    BILBrowser.this.index = 0;
                    canvas.redraw();
                }
            });
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    status.setText(event.text);
                }
            });
            if (parent instanceof Shell) {
                final Shell shell = (Shell)parent;
                this.browser.addTitleListener(new TitleListener(){

                    public void changed(TitleEvent event) {
                        shell.setText(String.valueOf(event.title) + " - " + BILBrowser.getResourceString("window.title"));
                    }
                });
            }
            itemBack.addListener(13, listener);
            itemForward.addListener(13, listener);
            itemStop.addListener(13, listener);
            itemRefresh.addListener(13, listener);
            itemGo.addListener(13, listener);
            itemHome.addListener(13, listener);
            this.location.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    BILBrowser.this.browser.setUrl(BILBrowser.this.location.getText());
                }
            });
            BILBrowser.initialize(display, this.browser);
            String url = this.getProjectURL();
            if (url == null || url.equals("")) {
                this.browser.setUrl("http://www.backbase.com");
            } else {
                this.browser.setUrl(url);
            }
        }
    }

    private String getProjectURL() {
        String projectURL = "http://www.backbase.com";
        try {
            IEditorPart editorPart = this.viewer.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
            if (editorPart != null) {
                IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
                IFile file = input.getFile();
                IProject activeProject = file.getProject();
                QualifiedName propertyName = new QualifiedName("", "projectURL");
                projectURL = activeProject.getPersistentProperty(propertyName);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return projectURL;
    }

    static String getResourceString(String key) {
        return BILPlugin.getResourceString(key);
    }

    static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(BILBrowser.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static void initialize(final Display display, Browser browser) {
        if (browser != null) {
            browser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    Shell shell = new Shell(display);
                    shell.setLayout((Layout)new FillLayout());
                    Browser browser = new Browser((Composite)shell, 0);
                    BILBrowser.initialize(display, browser);
                    event.browser = browser;
                }
            });
            browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent event) {
                }

                public void show(WindowEvent event) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    if (event.location != null) {
                        shell.setLocation(event.location);
                    }
                    if (event.size != null) {
                        Point size = event.size;
                        shell.setSize(shell.computeSize(size.x, size.y));
                    }
                    shell.open();
                }
            });
            browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent event) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.close();
                }
            });
        }
    }

    public void dispose() {
        this.browser.dispose();
    }

    public void setFocus() {
        if (this.location != null) {
            this.location.setFocus();
        }
    }
}

