/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.bxmleditor.views.contentoutline;

import com.backbase.bxmleditor.BILPluginImages;
import com.backbase.bxmleditor.dictionary.DictionaryManager;
import com.backbase.bxmleditor.dictionary.Parameter;
import com.backbase.bxmleditor.dictionary.SyntaxDictionary;
import com.backbase.bxmleditor.parser.TagItem;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class OutlineLabelProvider
extends LabelProvider {
    private SyntaxDictionary syntax = DictionaryManager.getDictionary("B_DICTIONARY");
    private Parameter p;

    public Image getImage(Object element) {
        if (element instanceof TagItem) {
            String tname = ((TagItem)element).getName();
            if (tname.equals("component")) {
                return BILPluginImages.get("class.gif");
            }
            if (tname.equals("object")) {
                return BILPluginImages.get("bean.gif");
            }
            if (tname.equals("function")) {
                return BILPluginImages.get("function.gif");
            }
            if (tname.equals("dump")) {
                return BILPluginImages.get("dump.gif");
            }
            if (tname.equals("script")) {
                return BILPluginImages.get("script.gif");
            }
            if (tname.equals("loop")) {
                return BILPluginImages.get("refresh.gif");
            }
            if (tname.equals("break")) {
                return BILPluginImages.get("delete.gif");
            }
            if (tname.equals("return")) {
                return BILPluginImages.get("back.gif");
            }
            if (tname.equals("query")) {
                return BILPluginImages.get("table.gif");
            }
            if (tname.equals("set")) {
                return BILPluginImages.get("add.gif");
            }
            if (tname.equals("directory")) {
                return BILPluginImages.get("dir.gif");
            }
            if (tname.equals("file")) {
                return BILPluginImages.get("file.gif");
            }
            if (tname.equals("invoke")) {
                return BILPluginImages.get("process.gif");
            }
            if (tname.equals("abort")) {
                return BILPluginImages.get("stop.gif");
            }
            if (tname.equals("ftp") || tname.equals("http") || tname.equals("ldap")) {
                return BILPluginImages.get("server.gif");
            }
            if (tname.equals("include") || tname.equals("module")) {
                return BILPluginImages.get("import.gif");
            }
            return BILPluginImages.get("element.gif");
        }
        return BILPluginImages.get("alert.gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(Object element) {
        if (element instanceof TagItem) {
            StringBuffer sb = new StringBuffer();
            String tname = ((TagItem)element).getName();
            sb.append(tname);
            if (this.hasSpecialNeeds(tname)) {
                String data = ((TagItem)element).getItemData();
                data = data.replaceAll("<b:" + tname, "");
                data = data.replaceAll("<s:" + tname, "");
                data = data.replaceAll(">", "");
                sb.append(data);
            } else {
                SyntaxDictionary syntaxDictionary = this.syntax;
                synchronized (syntaxDictionary) {
                    Set st = this.syntax.getElementAttributes(tname);
                    if (st != null) {
                        Iterator i = st.iterator();
                        while (i.hasNext()) {
                            String aval;
                            this.p = (Parameter)i.next();
                            if (!this.p.isRequired() || (aval = ((TagItem)element).getAttribute(this.p.getName())) == null || aval.length() <= 0) continue;
                            sb.append(" " + this.p.getName() + ": " + aval);
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "unknown (add to user.xml if custom)";
    }

    private boolean hasSpecialNeeds(String item) {
        return item.equals("if") || item.equals("set") || item.equals("loop") || item.equals("else") || item.equals("elseif") || item.equals("break") || item.equals("return") || item.equals("defaultcase") || item.equals("try") || item.equals("rethrow");
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException("Unknown type of element in tree of type " + element.getClass().getName());
    }

    public void dispose() {
    }
}

