#ifndef _MAIN_H_INCLUDED
#define _MAIN_H_INCLUDED

#include <windows.h>
#include "controls.h"

class WinException
{
public:
    WinException (char* msg)
    : _err (GetLastError()), _msg(msg)
    {}
    DWORD GetError() const { return _err; }
    char* GetMessage () const { return _msg; }
private:
    DWORD _err;
    char* _msg;
};

// out of memory handler that throws WinException
int NewHandler (size_t size);

class Controller
{
public:
    Controller(HWND hwnd);
    ~Controller ()
    {}
    void Command (HWND hwnd, int controlID, int command);
private:
    Edit        _edit;
    Button      _clear;
    Edit        _status;
    CheckBox    _leftCheck;
    CheckBox    _rightCheck;
    RadioButton _topRadio;
    RadioButton _middleRadio;
    RadioButton _bottomRadio;
    Button      _button1;
    Button      _button2;
    Button      _button3;
};

#endif // _MAIN_H_INCLUDED
