#include <new.h>
#include "main.h"
#include "rc.h"

HINSTANCE TheInstance = 0;

int NewHandler (size_t size)
{
    throw WinException ( "Out of memory" );
    return 0;
}

Controller::Controller (HWND hwnd)
    :	_edit		 (hwnd,	IDC_EDIT),
        _clear		 (hwnd,	IDC_CLEAR, FALSE),
        _status		 (hwnd,	IDC_STATUS),
        _leftCheck	 (hwnd,	IDC_LEFT),
        _rightCheck	 (hwnd,	IDC_RIGHT),
        _topRadio	 (hwnd,	IDC_TOP),
        _middleRadio (hwnd,	IDC_MIDDLE),
        _bottomRadio (hwnd,	IDC_BOTTOM),
        _button1	 (hwnd,	IDC_BUTTON1),
        _button2	 (hwnd,	IDC_BUTTON2),
        _button3	 (hwnd,	IDC_BUTTON3)
{
    // Attach icon to main dialog
    HICON hIcon = LoadIcon (TheInstance, MAKEINTRESOURCE (DLG_ICON));
    SendMessage (hwnd, WM_SETICON, WPARAM (TRUE), LPARAM (hIcon));
    hIcon = LoadIcon (TheInstance, MAKEINTRESOURCE (DLG_ICON_S));
    SendMessage (hwnd, WM_SETICON, WPARAM (FALSE), LPARAM (hIcon));

    // Other initializations...
    _edit.SetFocus();
    _leftCheck.Check();
    _topRadio.Select();
}

void Controller::Command (HWND hwnd, int controlID, int command)
{
    char statusMessage[64];

    switch (controlID)
    {
        case IDC_EDIT:
            if (_edit.IsChanged(command))
            {
                if (_edit.GetLength())
                    _clear.Enable();
                else
                    _clear.Disable();
            }
            break;
        case IDC_CLEAR:
            _edit.SetString("");
            _clear.Disable();
            _edit.SetFocus();
            _status.SetString("Edit field cleared.");
            break;
        case IDC_LEFT:
            if (command == BN_CLICKED)
            {
                strcpy(statusMessage, "Left checkbox clicked");
                if (_leftCheck.IsChecked())
                    strcat(statusMessage, ": CHECKED");
                _status.SetString(statusMessage);
            }
            break;
        case IDC_RIGHT:
            if (command == BN_CLICKED)
            {
                strcpy(statusMessage, "Right checkbox clicked");
                if (_rightCheck.IsChecked())
                    strcat(statusMessage, ": CHECKED");
                _status.SetString(statusMessage);
            }
            break;
        case IDC_TOP:
            if (command == BN_CLICKED)
                _status.SetString("Top radio button selected.");
            break;
        case IDC_MIDDLE:
            if (command == BN_CLICKED)
                _status.SetString("Middle radio button selected.");
            break;
        case IDC_BOTTOM:
            if (command == BN_CLICKED)
                _status.SetString("Bottom radio button selected.");
            break;
        case IDC_BUTTON1:
            if (command == BN_CLICKED)
                _status.SetString("Button1 clicked.");
            break;
        case IDC_BUTTON2:
            if (command == BN_CLICKED)
            {
                // Hide button 3 if it's visible
                if (_button3.IsVisible())
                {
                    _button3.Hide();
                    _status.SetString("Button3 hidden.");
                    _button2.SetName("Show button3");
                }
                else
                {
                    _button3.Show();
                    _status.SetString("Button3 shown.");
                    _button2.SetName("Hide button3");
                }
            }
            break;
        case IDC_BUTTON3:
            if (command == BN_CLICKED)
                _status.SetString("Button3 clicked.");
            break;
    }
}

BOOL CALLBACK DialogProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static Controller* control = 0;
    switch (message)
    {
    case WM_INITDIALOG:
        try
        {
            control = new Controller (hwnd);
        }
        catch (WinException e)
        {
            MessageBox (0, e.GetMessage (), "Exception", MB_ICONEXCLAMATION | MB_OK);
        }
        catch (...)
        {
            MessageBox (0, "Unknown", "Exception", MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        return TRUE;
    case WM_COMMAND:
        control->Command(hwnd, LOWORD(wParam), HIWORD (wParam));
        return TRUE;
    case WM_DESTROY:
        PostQuitMessage(0);
        return TRUE;
    case WM_CLOSE:
        delete control;
        DestroyWindow (hwnd);
        return TRUE;
    }
    return FALSE;
}

int WINAPI WinMain
   (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
    TheInstance = hInst;
    _set_new_handler (&NewHandler);

    HWND hDialog = 0;

    hDialog = CreateDialog (hInst, MAKEINTRESOURCE (DLG_MAIN), 0, (DLGPROC)DialogProc);
    if (!hDialog)
    {
        char buf [100];
        wsprintf (buf, "Error x%x", GetLastError ());
        MessageBox (0, buf, "CreateDialog", MB_ICONEXCLAMATION | MB_OK);
        return 1;
    }

    MSG  msg;
    int status;
    while ((status = GetMessage (&msg, 0, 0, 0)) != 0)
    {
        if (status == -1)
            return -1;
        if (!IsDialogMessage (hDialog, &msg))
        {
            TranslateMessage ( &msg );
            DispatchMessage ( &msg );
        }
    }

    return msg.wParam;
}