#if !defined TYPE_LIB
#define TYPE_LIB
//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------

#include "Interfaces.h"
#include "OleBase.h"
#include "HEx.h"

//
// Type Library from exe or dll
//
class TypeLibrary
{
    friend class TypeInfo;
public:
    // Can use name if found on the PATH
    TypeLibrary (WCHAR * path);
    ~TypeLibrary ()
    {
        if (_iLib != 0)
            _iLib->Release ();
    }
    bool IsOk () const { return _iLib != 0; }
    int GetCount ()
    {
        return _iLib->GetTypeInfoCount ();
    }
    void GetDocumentation (int idx, BString & name, BString & doc);
private:
    ITypeInfo * GetTypeInfo (int idx);
    ITypeInfo * GetTypeInfo (WCHAR * name);
private:
    ITypeLib * _iLib;
};

//
// Type info for a given element of the library
//
class TypeInfo: public SFace<ITypeInfo>
{
    friend class SObject;
public:
    TypeInfo (TypeLibrary & lib, int idx);
    TypeInfo (TypeLibrary & lib, WCHAR * name);
    ~TypeInfo ()
    {
        _i->ReleaseTypeAttr (_attr);
    }
    GUID & GetGuid () const { return _attr->guid; }
    void GetDocumentation (BString & name, BString & doc);
private:
    void * CreateInstance (IID const & iid);
private:
    TYPEATTR  * _attr;
};

//
// Regular library dynamically loaded from a dll
//
class Library
{
public:
    Library (char * path)
        : _hInst (::LoadLibrary (path))
    {
        if (_hInst == 0)
            throw "Couldn't load library";
    }
    ~Library ()
    {
        if (_hInst != 0)
            FreeLibrary (_hInst);
    }
    FARPROC GetProcedure (char * name)
    {
        return ::GetProcAddress (_hInst, name);
    }
private:
    HINSTANCE _hInst;
};



#endif
