//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------
#include "OleBase.h"
#include "TypeLib.h"
#include "DispObjects.h"
#include "DocObj.h"
#include "main.h"
#include "objmodel\\appauto.h"
#include "objmodel\\appguid.h"
#include "objmodel\\textauto.h"
#include "objmodel\\textguid.h"
#include "canvas.h"

void PeekApp (Canvas & canvas)
{
    int y = 2;
    try
    {
        // {FB7FDAE2-89B8-11CF-9BE8-00A0C90A632C}
        CLSID idMsDev;
        HRESULT hr = ::CLSIDFromProgID (L"MSDEV.APPLICATION", &idMsDev);
        if (FAILED (hr))
            throw HEx (hr, "Couldn't convert prog id to class id");
        SObject obj (idMsDev, true);
        SObjFace<IApplication, &IID_IApplication> app (obj);

        VARIANT_BOOL b = VARIANT_TRUE;
        app->put_Visible (b);

        SActiveDocument docObj (app); // a dispatch object among others

        if (!docObj)
        {
            canvas.Text (10, 10, "No active document");
        }
        else
        {
            // Use docObj as a dispatch interface
            DISPID pid = docObj.GetDispId (L"Name");
        	VARIANT varResult ;
	        ::VariantInit(&varResult) ;
            docObj.GetProperty (pid, varResult);
            BString bName (varResult);
            CString cName (bName);
            canvas.Text (20, y, "Name:");
            canvas.Text (200, y, cName);

            y += 20;

            // Get vtable interface for this document
            SObjFace<IGenericDocument, &IID_IGenericDocument> doc (docObj);

            BString bPath;
            doc->get_FullName (bPath.GetPointer ());
            CString path (bPath);
            canvas.Text (20, y, "Active Document:");
            canvas.Text (200, y, path);

            y += 20;

            BString bType;
            doc->get_Type (bType.GetPointer ());
            CString type (bType);
            canvas.Text (20, y, "Type:");
            canvas.Text (200, y, type);

            y += 20;

            if (type.IsEqual ("Text"))
            {
                SObjFace<ITextDocument, &IID_ITextDocument> text (docObj);
                SSelection selObj (text);
                SObjFace<ITextSelection, &IID_ITextSelection> sel (selObj);
                long line;
                sel->get_CurrentLine (&line);
                canvas.Text (20, y, "CurrentLine:");
                char buf [10];
                wsprintf (buf, "%ld", line);
                canvas.Text (200, y, buf);
            }
        }
    }
    catch (HEx & hex)
    {
        hex.Display (20, 100, canvas);
    }
    catch (char const * str)
    {
        canvas.Text (10, 10, str);
    }
    catch (...)
    {
        char msg [] = "Unknown exception";
        canvas.Text (10, 10, msg);
    }
}

int WINAPI WinMain
   (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
    char className [] = "OleTest";

    WindowClass winClass (WndProc, className, hInst);
    winClass.Register ();

    Window win ("MS DevStudio Peep Show", className, hInst);
    win.Show (cmdShow);

    MSG  msg;
    int status;
    while ((status = GetMessage (&msg, 0, 0, 0)) != 0)
    {
        if (status == -1)
            return -1;
        DispatchMessage (&msg);
    }

    return msg.wParam;
}

WindowClass::WindowClass (WNDPROC WndProc, char const * className, HINSTANCE hInst)
{
    style = 0;
    lpfnWndProc = WndProc;       // window procedure: mandatory
    cbClsExtra = 0;
    cbWndExtra = 0;
    hInstance = hInst;           // owner of the class: mandatory
    hIcon = 0;
    hCursor = LoadCursor (0, IDC_ARROW); // optional
    hbrBackground = (HBRUSH) (COLOR_WINDOW + 1); // optional
    lpszMenuName = 0;
    lpszClassName = className;   // mandatory
}

Window::Window 
    (char const * caption, char const * className, HINSTANCE hInstance)
{
    _hwnd = CreateWindow (
        className,              // name of a registered window class
        caption,                // window caption
        WS_OVERLAPPEDWINDOW,    // window style
        CW_USEDEFAULT,          // x position
        CW_USEDEFAULT,          // y position
        CW_USEDEFAULT,          // witdh
        CW_USEDEFAULT,          // height
        0,                      // handle to parent window
        0,                      // handle to menu
        hInstance,              // application instance
        0 );                    // window creation data
}

class Controller
{
public:
    Controller(HWND hwnd, CREATESTRUCT * pCreate)
    {
    }
    ~Controller()
    {
        PostQuitMessage(0);
    }
    void Paint (HWND hwnd);
private:
    UseOle useOle;
};

void Controller::Paint (HWND hwnd)
{
    ::InvalidateRect (hwnd, 0, TRUE);
    PaintCanvas canvas (hwnd);
    PeekApp (canvas);
}
// Window Proc called by Windows

LRESULT CALLBACK WndProc 
    (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static Controller * pCtrl;

    switch (message)
    {
    case WM_CREATE:
        try
        {
            pCtrl = new Controller (hwnd, (CREATESTRUCT *) lParam);
        }
        catch (char const * str)
        {
            MessageBox (hwnd, str, "Initialization", 
                MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        catch (...)
        {
            MessageBox (hwnd, "Unknown Error", "Initialization", 
                MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        return 0;
    case WM_PAINT:
         pCtrl->Paint (hwnd);
         return 0;
    case WM_DESTROY:
        delete pCtrl;
        return 0;

    }
    return DefWindowProc (hwnd, message, wParam, lParam );
}

