#if !defined INTERFACES_H
#define INTERFACES_H
//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------

#include "Objects.h"

//
// Smart Interface Base Class
//

template<class I>
class SFace
{
public:
    ~SFace ()
    {
        if (_i)
            _i->Release ();
    }
    I * operator-> () { return _i; }
protected:
    SFace () : _i (0) {}
    SFace (void * i)
    {
        _i = static_cast<I*> (i);
    }
protected:
    I * _i;
};


//
// Interface from Object
//

template<class I, IID const * iid>
class SObjFace: public SFace<I>
{
public:
    SObjFace (CoObject & obj)
        : SFace<I> (obj.AcquireInterface (*iid))
    {}
};

#endif
