#if !defined OLE_BASE
#define OLE_BASE
//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------

#include <objbase.h>

//
// Make it global or subobject of long living major object
//
class UseOle
{
public:
    UseOle () { OleInitialize (0); }
    ~UseOle () { OleUninitialize (); }
};

//
// Strings
//

class BString
{
    friend class CString;
public:
    BString ()
        :_str (0)
    {}
    BString (VARIANT & var)
    {
        if (var.vt != VT_BSTR)
        {
            throw "Variant type is not a BSTR";
        }
        _str = var.bstrVal;
    }
    BString (WCHAR * str)
        :_str (::SysAllocString (str))
    {}
    ~BString ()
    {
        // Works for null string, too.
        ::SysFreeString (_str);
    }
    BSTR * GetPointer () { return &_str; }
protected:
    BSTR _str;
};

class CString
{
public:
    CString (BString & bstr)
        :_len (::SysStringLen (bstr._str))
    {
        _str = new char [_len + 1];
        wcstombs (_str, bstr._str, _len);
        _str [_len] = '\0';
    }
    ~CString ()
    {
        delete []_str;
    }
    operator char const * () const { return _str; }
    int Len () { return _len; }
    bool IsEqual (char const * str)
    {
        return strcmp (str, _str) == 0;
    }
protected:
    char * _str;
    int    _len;
};

#endif
