#if !defined H_EX_H
#define H_EX_H

#include "canvas.h"

class HEx
{
public:
    HEx (HRESULT hr, char const * str = 0)
        : _hr (hr), _str (str)
    {}
    void Display (int x, int y, Canvas & canvas)
    {
        if (_str != 0)
        {
            canvas.Text (x, y, _str);
            y += 20;
        }
        if (FAILED (_hr))
        {
            char * msg;
            ::FormatMessage (
                FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                0,
                _hr,
                MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT),
                reinterpret_cast<char *> (&msg),
                0,
                0);
            canvas.Text (x, y, msg);
            LocalFree (msg);
        }
    }
private:
    HRESULT _hr;
    char const * _str;
};

#endif