//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------

#include "Objects.h"
#include "TypeLib.h"
#include "HEx.h"

SObject::SObject (CLSID const & classId, bool running)
    :_iUnk (0)
{
    HRESULT hr = S_OK;
    if (running)
    {
        ::GetActiveObject (classId, 0, &_iUnk);
    }
    if (_iUnk == 0)
    {
        hr = ::CoCreateInstance (classId, 0, CLSCTX_SERVER, IID_IUnknown, (void**)&_iUnk);
    }
    if (FAILED (hr))
        throw HEx (hr, "Couldn't create instance");
}

SObject::SObject (TypeInfo & info)
    : _iUnk (0)
{
    _iUnk = reinterpret_cast<IUnknown *>(info.CreateInstance (IID_IUnknown));
}

void * SObject::AcquireInterface (IID const & iid)
{
    void * p = 0;
    HRESULT hr = _iUnk->QueryInterface (iid, &p);
    if (FAILED (hr))
    {
        if (hr == E_NOINTERFACE)
            throw "No such interface";
        else
            throw HEx (hr, "Couldn't query interface");
    }
    return p;
}
