#if !defined DISP_OBJECTS
#define DISP_OBJECTS
//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------

#include <objbase.h>
#include <unknwn.h>
#include "HEx.h"

class DispObject: public CoObject
{
public:
    DispObject (CLSID const & classId)
        :_iDisp (0)
    {
        HRESULT hr = ::CoCreateInstance (classId, 0, CLSCTX_ALL, IID_IDispatch, (void**)&_iDisp);
        if (FAILED (hr))
        {
            if (hr == E_NOINTERFACE)
                throw "No IDispatch interface";
            else
                throw HEx (hr, "Couldn't create DispObject");
        }
    }

    ~DispObject ()
    {
        if (_iDisp)
            _iDisp->Release ();
    }

    operator bool () const { return _iDisp != 0; }
    bool operator ! () const { return _iDisp == 0; }

    DISPID GetDispId (WCHAR * funName)
    {
        DISPID dispid;
        HRESULT hr = _iDisp->GetIDsOfNames (IID_NULL, &funName, 1, GetUserDefaultLCID (), &dispid);
        return dispid;
    }

    void GetProperty (DISPID propId, VARIANT & result)
    {
        // In parameters
        DISPPARAMS args = { 0, 0, 0, 0 };
        EXCEPINFO except;
        UINT argErr;
        HRESULT hr = _iDisp->Invoke (propId, 
            IID_NULL, 
            GetUserDefaultLCID (), 
            DISPATCH_PROPERTYGET, 
            &args,
            &result,
            &except,
            &argErr);
        if (FAILED (hr))
            throw HEx (hr, "Couldn't get property");
    }


    void * AcquireInterface (IID const & iid)
    {
        void * p = 0;
        HRESULT hr = _iDisp->QueryInterface (iid, &p);
        if (FAILED (hr))
        {
            if (hr == E_NOINTERFACE)
                throw "No such interface";
            else
                throw HEx (hr, "Couldn't query interface");
        }
        return p;
    }

protected:
    DispObject (IDispatch * iDisp) : _iDisp (iDisp) {}
    DispObject () : _iDisp (0) {}
protected:
    IDispatch * _iDisp;
};

#endif