#if !defined OBJECTS_H
#define OBJECTS_H
//------------------------------------
//  (c) Reliable Software, 1997
//   Top level include
//------------------------------------

#include <objbase.h>
#include <unknwn.h>

class TypeInfo;

//
// COM object: provider of interfaces
//

class CoObject
{
public:
    virtual void * AcquireInterface (IID const & iid) = 0;
};

//
// Smart COM object created using CoCreateInstance
//

class SObject: public CoObject
{
public:
    SObject (CLSID const & classId, bool running = false);
    SObject (TypeInfo & info);
    ~SObject ()
    {
        if (_iUnk)
            _iUnk->Release ();
    }
    void * AcquireInterface (IID const & iid);

private:
    IUnknown * _iUnk;
};

#endif