//------------------------------------
//  control.cpp
//  (c) Bartosz Milewski, 1992, 1995
//------------------------------------
#include "control.h"
#include "canvas.h"
#include "main.h"
#include "model.h"
#include "resource.h"
#include "editdlg.h"

// Window Proc

LRESULT CALLBACK WndProc
    (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static Controller * pCtrl;

    switch (message)
    {
    case WM_CREATE:
        try
        {
            pCtrl = new Controller (hwnd, (CREATESTRUCT *) lParam);
        }
        catch (WinException e)
        {
            MessageBox (hwnd, e.GetMessage(), "Initialization", 
                MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        catch (...)
        {
            MessageBox (hwnd, "Unknown Error", "Initialization", 
                MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        return 0;
    case WM_SIZE:
        pCtrl->Size(LOWORD(lParam), HIWORD(lParam));
        return 0;
    case WM_PAINT:
        pCtrl->Paint(hwnd);
        return 0;
    case WM_COMMAND:
        pCtrl->Command(hwnd, LOWORD (wParam));
        return 0;
    case WM_DESTROY:
        delete pCtrl;
        return 0;
    }
    return DefWindowProc (hwnd, message, wParam, lParam);
}

Controller::Controller (HWND hwnd, CREATESTRUCT * pCreate)
   :_model ("Generic"), _hInst (pCreate->hInstance)
{
}

Controller::~Controller()
{
    PostQuitMessage(0);
}

void Controller::Size (int cx, int cy)
{
    _view.SetSize (cx, cy);
}

void Controller::Paint (HWND hwnd)
{
    PaintCanvas canvasScreen (hwnd);
    _view.Paint (canvasScreen, _model);
}

// Menu commands processing

void Controller::Command (HWND hwnd, int cmd)
{
    switch (cmd)
    {
    case IDM_FILE_EDIT:
        Edit (hwnd);
        break;
    case IDM_EXIT:
        SendMessage (hwnd, WM_CLOSE, 0, 0L);
        break;
    case IDM_HELP:
        MessageBox (hwnd, "Go figure!",
            "Generic", MB_ICONINFORMATION | MB_OK);
        break;
    case IDM_ABOUT:
        DialogBox (_hInst, "About", hwnd, DLGPROC(AboutDlgProc));
        break;
    }
}

void Controller::Edit (HWND hwnd)
{
    EditorData data (_model.GetText ());
    ControllerFactory <EditorCtrl, EditorData> factory (&data);
    ModalDialog dialog (_hInst, hwnd, IDD_EDITDIALOG, &factory);
    if (dialog.IsOk ())
    {
        _model.SetText (data.GetName ());
        // Force repaint
        InvalidateRect (hwnd, 0, TRUE);
    }
}

// "About" dialog box procedure
// Process messages from dialog box

BOOL CALLBACK AboutDlgProc
   (HWND hwnd, UINT message, UINT wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_INITDIALOG:
        return TRUE;
    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
        case IDOK:
        case IDCANCEL:
            EndDialog(hwnd, 0);
            return TRUE;
        }
        break;
    }
    return FALSE;
}

