//------------------------------------
//  main.cpp
//  (c) Bartosz Milewski, 1992
//------------------------------------
#include "main.h"
#include <new.h>

int PASCAL WinMain
    (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
    char className [] = "Generic";
    _set_new_handler (&NewHandler);

    BOOL isError = FALSE;
    try
    {
        WindowClass winClass (WndProc, className, hInst);
        winClass.Register ();

        Window win ("Generic", className, hInst);
        win.Show ( cmdShow );
    }
    catch ( WinException e )
    {
        char buf [50];
        wsprintf ( buf, "%s, Error %d", e.GetMessage (), e.GetError () );
        MessageBox (0, buf, "Exception", MB_ICONEXCLAMATION | MB_OK);
        isError = TRUE;
    }
    catch (...)
    {
        MessageBox (0, "Unknown", "Exception", MB_ICONEXCLAMATION | MB_OK);
        isError = TRUE;
    }

    if (isError)
        return 0;

    // The main message loop
    MSG  msg;
    int status;
    while ((status = GetMessage (&msg, 0, 0, 0)) != 0)
    {
        if (status == -1)
            return -1;
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    return msg.wParam;
}            

WindowClass::WindowClass (WNDPROC WndProc, char const * className, HINSTANCE hInst)
{
    cbSize = sizeof (WNDCLASSEX);
    style = CS_HREDRAW | CS_VREDRAW;
    lpfnWndProc = WndProc;       // window procedure: mandatory
    cbClsExtra = 0;
    cbWndExtra = 0;
    hInstance = hInst;           // owner of the class: mandatory
    hIcon = LoadIcon (hInst, className);
    hIconSm = LoadIcon (hInst, "SMALL");
    hCursor = LoadCursor (0, IDC_ARROW); // optional
    hbrBackground = (HBRUSH) (COLOR_WINDOW + 1); // optional
    lpszMenuName = className;
    lpszClassName = className;   // mandatory
}

Window::Window (char const * caption, char const * className, HINSTANCE hInstance)
{
    _hwnd = CreateWindow (
        className,
        caption,
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL );
    if (_hwnd == 0)
        throw "Window Creation Failed";
}

int NewHandler (size_t size)
{
    throw WinException ( "Out of memory" );
    return 0;
}


