#if !defined CONTROLS_H
#define CONTROLS_H

#include <windows.h>

class SimpleControl
{
public:
    SimpleControl (HWND hwndParent, int id)
        : _hWnd (GetDlgItem (hwndParent, id))
    {}

    void SetFocus ()
    {
        ::SetFocus (_hWnd);
    }

    // code is the HIWORD (wParam)
    static BOOL IsClicked (int code)
    {
        return code == BN_CLICKED;
    }

    HWND Hwnd () const { return _hWnd; }

    void Enable ()
    {
        EnableWindow (_hWnd, TRUE);
    }

    void Disable ()
    {
        EnableWindow (_hWnd, FALSE);
    }

    void SetFont (HFONT font)
    {
        SendMessage ( Hwnd (), WM_SETFONT, (WPARAM) font, MAKELPARAM(TRUE, 0));
    }
protected:
    HWND _hWnd;
};


class Edit: public SimpleControl
{
public:
    Edit (HWND hwndParent, int id)
        : SimpleControl (hwndParent, id)
    {}

    void SetString (char const * buf)
    {
        SendMessage (Hwnd (), WM_SETTEXT, 0, (LPARAM) buf);
    }

    // code is the HIWORD (wParam)
    static BOOL IsChanged (int code)
    { 
        return code == EN_CHANGE;
    }

    int GetLen ()
    {
        return SendMessage (Hwnd (), WM_GETTEXTLENGTH, 0, 0);
    }

    void GetString (char* buf, int len)
    {
        SendMessage (Hwnd (), WM_GETTEXT, (WPARAM) len, (LPARAM) buf);
    }

    void Select ()
    {
        SendMessage (Hwnd (), EM_SETSEL, 0, -1);
    }
};

#endif
