//------------------------------------
//  newproj.cpp
//  (c) Reliable Software, 1996
//------------------------------------

#include "resource.h"
#include "controls.h"

#include <windows.h>
#include "editdlg.h"

void EditorCtrl::OnInitDialog (HWND hwnd)
{
    char const * name = _dlgData->GetName ();
    _nameEdit.SetString (name);
}

bool EditorCtrl::OnCommand (HWND hwnd, int ctrlID, int notifyCode)
{
    switch (ctrlID)
    {
    case IDC_NAME_EDIT:
        if (_nameEdit.IsChanged (notifyCode))
        {
            char nameBuf [EditorData::maxLen];
            int len = _nameEdit.GetLen ();
            if (len < EditorData::maxLen)
            {
                _nameEdit.GetString (nameBuf, sizeof (nameBuf));
                _dlgData->SetName (nameBuf);
            }
            return true;
        }
        break;
    case IDOK:
        if (_dlgData->IsNameOK ())
        {
            EndDialog(hwnd, TRUE);
        }
        else
        {
            MessageBox (hwnd, "Please, enter valid name", "Name Editor",
                            MB_ICONINFORMATION | MB_OK);
        }
        return true;
    case IDCANCEL:
        EndDialog(hwnd, FALSE);
        return true;
    }
    return false;
}

bool EditorCtrl::OnNotify (HWND hwnd, int idCtrl, NMHDR *hdr)
{
    return false;
}
