#if !defined EDITOR_H
#define EDITOR_H
//------------------------------------
//  (c) Reliable Software, 1996
//------------------------------------

#include "modaldlg.h"
#include "controls.h"

class EditorData
{
public:
    enum { maxLen = 128 };

    EditorData (char const * name)
    {
        SetName (name);
    }

    BOOL IsNameOK () { return (_name[0] != '\0'); }

    void SetName (char const *name)
    { 
        strcpy (_name, name);
    }

    char const *GetName () { return _name; }

private:
    char        _name [maxLen];
};

class EditorCtrl : public DlgController
{
public:
    EditorCtrl (HWND hwndDlg, void *argList)
        : DlgController (argList),
          _nameEdit (hwndDlg, IDC_NAME_EDIT)
    {
        _dlgData = (EditorData *) GetArgList ();
    }

    void OnInitDialog (HWND hwnd);
    bool OnCommand (HWND hwnd, int ctrlID, int notifyCode);
    bool OnNotify (HWND hwnd, int idCtrl, NMHDR *hdr);

private:
    Edit        _nameEdit;
    EditorData *_dlgData;
};

#endif
