#if !defined MAIN_H
#define MAIN_H
//------------------------------------
//  main.h
//  Generic Windows Program
//  (c) Bartosz Milewski, 1992, 97
//------------------------------------

#include <windows.h>

// procedures called by Windows

LRESULT CALLBACK WndProc
   ( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam );

BOOL CALLBACK AboutDlgProc
   ( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam );

class WinException
{
public:
    WinException (char* msg)
    : _err (GetLastError()), _msg(msg)
    {}
    DWORD GetError() const { return _err; }
    char* GetMessage () const { return _msg; }
private:
    DWORD _err;
    char* _msg;
};

// out of memory handler that throws WinException
int NewHandler (size_t size);

class WindowClass: public WNDCLASSEX
{
public:
    WindowClass (WNDPROC WndProc, char const * className, HINSTANCE hInst);
    void Register ()
    {
        if (RegisterClassEx (this) == 0)
            throw WinException ("RegisterClassEx");
    }
};

// Window (needed by Windows)

class Window
{
public:
    Window (): _hwnd(0) {}
    Window ( char const * caption, char const * className, HINSTANCE hInstance );
    void Show ( int nCmdShow )
    {
        ::ShowWindow ( _hwnd, nCmdShow );
        ::UpdateWindow ( _hwnd );
    }
    operator HWND() { return _hwnd; }
protected:
    HWND _hwnd;
};

#endif

