//------------------------------------
//  modaldlg.cpp
//  (c) Reliable Software, 1996, 97
//------------------------------------

#include "modaldlg.h"

// Getting and Setting WindowLong: default is GWL_USERDATA

template <class T>
inline T GetWinLong (HWND hwnd, int which = GWL_USERDATA)
{
    return reinterpret_cast<T> (::GetWindowLong (hwnd, which));
}

template <class T>
inline void SetWinLong (HWND hwnd, T value, int which = GWL_USERDATA)
{
    ::SetWindowLong (hwnd, which, reinterpret_cast<long> (value));
}


// Modal dialog box procedure
// Process messages from dialog box
// by passing them to client-defined controller object

BOOL CALLBACK ModalDialog::ModalDialogProc (HWND hwnd, 
                                            UINT message, 
                                            WPARAM wParam, 
                                            LPARAM lParam)
{
	DlgController * ctrl = GetWinLong<DlgController *> (hwnd);
    switch (message)
    {
    case WM_INITDIALOG:
        {
            CtrlFactory *ctrlFactory = reinterpret_cast<CtrlFactory *> (lParam);
			ctrl = ctrlFactory->MakeController (hwnd);
			SetWinLong<DlgController *> (hwnd, ctrl);
            ctrl->OnInitDialog (hwnd);
        }
        return TRUE;

    case WM_COMMAND:
        if (ctrl && ctrl->OnCommand (hwnd, LOWORD(wParam), HIWORD (wParam)))
            return TRUE;    // Windows doesn't understand bool::true
        break;

    case WM_NOTIFY:
        if (ctrl && ctrl->OnNotify (hwnd, wParam, reinterpret_cast<NMHDR *>(lParam)))
            return TRUE;    // Windows doesn't understand bool::true
        break;
	case WM_DESTROY:
		delete ctrl;
		SetWinLong<DlgController *> (hwnd, 0);
		break;
    }
    return FALSE;
}
