#if !defined MODALDLG_H
#define MODALDLG_H
//------------------------------------
//  modaldlg.h
//  (c) Reliable Software, 1996, 97
//------------------------------------

#include <windows.h>

class DlgController;

class CtrlFactory
{
public:
    CtrlFactory (void *argList) : _argList (argList) {}

    void *GetArgList () { return _argList; }
    virtual DlgController * MakeController (HWND hwndDlg) = 0;

private:
    void *_argList;
};

// Parametrized by class MyCtrl derived from DlgController
// and MyArgList that encapsulates in/out arguments to the dialog

template <class MyCtrl, class MyArgList>
class ControllerFactory : public CtrlFactory
{
public:
    ControllerFactory (void * argList) : CtrlFactory (argList) {}
    DlgController * MakeController (HWND hwndDlg)
    {
        return new MyCtrl (hwndDlg, (MyArgList *) GetArgList ());
    }
};

// Subclass this and define your own class for in/out argList

class DlgController
{
public:
    virtual ~DlgController () {}
    virtual void OnInitDialog (HWND hwnd) = 0;
    virtual bool OnCommand (HWND hwnd, int ctrlID, int notifyCode) = 0;
    virtual bool OnNotify (HWND hwnd, int idCtrl, NMHDR *hdr) = 0;

    void * GetArgList () { return _argList; }

protected:
    DlgController (void * argList) : _argList (argList) {}

private:
    void * _argList;
};

class ModalDialog
{
public:
    ModalDialog (HINSTANCE hInst, 
                 HWND hwnd, 
                 int dlgResource, 
                 CtrlFactory *ctrlFactory)
    {
        _result = DialogBoxParam (hInst,
                                  MAKEINTRESOURCE (dlgResource),
                                  hwnd,
                                  (DLGPROC) ModalDialogProc,
                                  (LPARAM) ctrlFactory);
    }

    bool IsOk () const { return (_result == -1)? false: _result != 0; }

    static BOOL CALLBACK ModalDialogProc (HWND hwnd, 
                                          UINT message, 
                                          WPARAM wParam, 
                                          LPARAM lParam);
private:
    int                    _result;
};

#endif
