#if !defined (WIN_H)
#define WIN_H
//-------------------------------------
// Copyright (c) Reliable Software 1998
//-------------------------------------
#include <windows.h>
#include <cassert>

namespace Win
{
	template <class T>
	inline T GetLong (HWND hwnd, int which = GWL_USERDATA)
	{
		return reinterpret_cast<T> (::GetWindowLong (hwnd, which));
	}

	template <class T>
	inline void SetLong (HWND hwnd, T value, int which = GWL_USERDATA)
	{
		::SetWindowLong (hwnd, which, reinterpret_cast<long> (value));
	}

	class Queue
	{
	public:
		Queue (HWND h = 0): _h (h) {}
		void Init (HWND h) { _h = h; }
		operator HWND () const { return _h; }
		bool operator== (Queue h) const { return _h == h._h; }
		LRESULT SendMessage (UINT msg, WPARAM wparam = 0, LPARAM lparam = 0) const
		{
			assert (_h != 0);
			return ::SendMessage (_h, msg, wparam, lparam);
		}
		bool PostMessage (UINT msg, WPARAM wparam = 0, LPARAM lparam = 0) const
		{
			assert (_h != 0);
			return ::PostMessage (_h, msg, wparam, lparam) != FALSE;
		}
	protected:
		HWND	_h;
	};

	class H: public Queue
	{
	public:
		H (HWND h = 0) : Queue (h) {}
		HINSTANCE GetInstance () const
		{ 
			return reinterpret_cast<HINSTANCE> (::GetWindowLong (_h, GWL_HINSTANCE));		
		}
		HWND GetParent () const
		{
			return ::GetParent (_h);
		}
		void SetParent (HWND hwndParent)
		{
			::SetParent (_h, hwndParent);
		}
		// Destroying
		void Destroy ()
		{
			::DestroyWindow (_h);
		}
		// Coordinates
		void ClientToScreen (POINT & pt)
		{
			::ClientToScreen (_h, &pt);
		}
		// Messages
		long SendMessageTo (int idChild, UINT msg, WPARAM wparam = 0, LPARAM lparam = 0) const
		{
			return ::SendDlgItemMessage (_h, idChild, msg, wparam, lparam);
		}
		// Register window for drag/drop messages
		void DragAcceptFiles ()
		{
			::DragAcceptFiles (_h, TRUE);
		}
		// Focus
		void SetFocus ()
		{ 
			::SetFocus (_h); 
		}
		bool HasFocus () const
		{
			return ::GetFocus () == _h;
		}
		// Timer
		void SetTimer (int idTimer, int milliSec)
		{
			::SetTimer (_h, idTimer, milliSec, 0);
		}
		void KillTimer (int idTimer)
		{
			::KillTimer (_h, idTimer);
		}
		// Mouse capture
		void CaptureMouse ()
		{
			::SetCapture (_h);
		}
		static void ReleaseMouse ()
		{
			::ReleaseCapture ();
		}
		bool HasCapture () const
		{
			return ::GetCapture () == _h;
		}
		// Text/Caption
		void SetText (char const * text) 
		{ 
			::SetWindowText (_h, text); 
		}
		int GetText (char * buf, int len) const// len includes null
		{ 
			return ::GetWindowText (_h, buf, len); 
		}
		// Font
		void SetFont (HFONT hFont)
		{
			BOOL fRedraw = TRUE;
			SendMessage (WM_SETFONT, (WPARAM) hFont, MAKELPARAM (fRedraw, 0));
		}
		// Visibility
		void Enable ()
		{
			::EnableWindow (_h, true);
		}

		void Disable ()
		{
			::EnableWindow (_h, false);
		}
		void Show (int cmdShow = SW_SHOW) 
		{ 
			::ShowWindow (_h, cmdShow); 
		}
		void Hide () 
		{ 
			::ShowWindow (_h, SW_HIDE); 
		}
		void Update () 
		{ 
			::UpdateWindow (_h); 
		}
		void SetForeground ()
		{
			::SetForegroundWindow (_h);
		}
		// Moving
		void Move (int x, int y, int width, int height)
		{
			::MoveWindow (_h, x, y, width, height, TRUE);
		}
		void MoveDelayPaint (int x, int y, int width, int height)
		{
			::MoveWindow (_h, x, y, width, height, FALSE);
		}
		// Rectangles
		void GetClientRect (RECT & rect)
		{
			::GetClientRect (_h, &rect);
		}
		void GetWindowRect (RECT & rect)
		{
			::GetWindowRect (_h, &rect);
		}
		// Repainting
		void Invalidate (bool fErase = true)
		{
			::InvalidateRect (_h, 0, fErase? TRUE: FALSE);
		}
		void Invalidate (RECT const & rect, bool fErase = true)
		{
			::InvalidateRect (_h, &rect, fErase? TRUE: FALSE);
		}
		void ForceRepaint ()
		{
			Invalidate ();
			Update ();
		}
		// Scrolling
		void Scroll (int xAmount, int yAmount)
		{
			::ScrollWindow (_h, xAmount, yAmount, 0, 0);
		}
		void Scroll (RECT & rect, int xAmount, int yAmount)
		{
			::ScrollWindow (_h, xAmount, yAmount, &rect, 0);
		}
	};
}

#endif
