#if !defined (WINCLASS_H)
#define WINCLASS_H
//-------------------------------------
// Copyright (c) Reliable Software 1998
//-------------------------------------

#include "Resources.h"
#include <windows.h>
#include <string>

namespace Win
{
	class SimpleClass
	{
	public:
		SimpleClass (char const * name)
			: _name (name)
		{}
		char const * GetName () const { return _name.c_str (); }
		HWND GetRunningWindow ();
	protected:
		std::string	_name;
	};

	class Class: public SimpleClass
	{
	public:
		Class (char const * name, Resources & res);
		void Register ();
		void SetIcons (int id);
		void SetMenu (int id);
	protected:
		void SetDefaults ();

		static LRESULT CALLBACK Procedure
							(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

		WNDCLASSEX	_class;
		StdIcon		_stdIcon;
		SmallIcon	_smallIcon;
	};
}

#endif
