//-------------------------------------
// Copyright Reliable Software (c) 1999
//-------------------------------------
#include "World.h"
#include <cmath>
#include <cassert>

World::World (HINSTANCE hInst, int idBmp) 
	: _tick (0), _texture (hInst, idBmp)
{
}

COLORREF World::GetTexel (double u, double v)
{
	assert (u >= 0 && u < 1.0);
	assert (v >= 0 && v < 1.0);
	// rotate around the center
	u -= 0.5;
	v -= 0.5;
	double c = cos (_tick * 0.01);
	double s = sin (_tick * 0.01);
	double uRot = 0.5 + u * c + v * s;
	double vRot = 0.5 + v * c - u * s;

	// clip back to square
	if (uRot >= 0 && uRot < 1.0 && vRot >= 0 && vRot < 1.0)
		return _texture.GetTexel (uRot, vRot);
	else
		return RGB (255, 255, 255); // white corners
}
