#include "control.h"
#include "World.h"
#include "resources\resource.h"
#include "lib\canvas.h"
#include "lib\Tools.h"
#include <numeric>
//-------------------------------------
// Copyright Reliable Software (c) 1999
//-------------------------------------

void Controller::Create (CREATESTRUCT * create)
{
	_timer.Create (_h, 1);
	_world = new World (create->hInstance, IDB_RS);
	_view.Create (_h, _world);
	_timer.Set (10);
}

Controller::~Controller ()
{
	delete _world;
}

bool Controller::SysCommand (int cmd)
{
	// disable screen savers
	if (cmd == SC_SCREENSAVE || cmd == SC_MONITORPOWER)
		return true;
	return false;
}

bool Controller::Timer (int id, TIMERPROC * proc)
{
	_timer.Kill ();
	_world->Step ();

	_view.Update ();
	// force repaint
	_h.Invalidate (false);
	_timer.Set (10);
	return true;
}

bool Controller::Size (int width, int height)
{
	_view.Size (_h, width, height);
	_view.Update ();
	// force repaint
	_h.Invalidate (false);
	return true;
}

bool Controller::Paint (HDC hdc)
{
	_view.Paint (_h);
	// validate painted area
	PaintCanvas canvas (_h);
	return true;
}

void Controller::Exit ()
{
    _h.Destroy ();
}


