#if !defined (BITMAP_H)
#define BITMAP_H
//-------------------------------------
// Copyright Reliable Software (c) 1999
//-------------------------------------
#include <windows.h>

class Bitmap
{
public:
	Bitmap ()
		: _hBitmap (0)
	{}
	Bitmap (Bitmap & bmp)
		: _hBitmap (bmp.Release ())
	{}
	Bitmap (HINSTANCE hInst, int id)
	{
		Load (hInst, id);
	}
	~Bitmap ()
	{
		Free ();
	}
	operator HBITMAP () const { return _hBitmap; }
	HBITMAP Release ()
	{
		HBITMAP h = _hBitmap;
		_hBitmap = 0;
		return h;
	}
	void operator = (Bitmap & bmp)
	{
		Free ();
		_hBitmap = bmp.Release ();
	}
	void CreateCompatible (HDC hdc, int width, int height)
	{
		Free ();
		_hBitmap = ::CreateCompatibleBitmap (hdc, width, height);
	}
    void Load (HINSTANCE hInst, char const * name)
    {
        _hBitmap = ::LoadBitmap (hInst, name);
    }
    void Load (HINSTANCE hInst, int id)
    {
        _hBitmap = (HBITMAP) ::LoadImage (hInst, 
			MAKEINTRESOURCE (id),
			IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION);
    }
	void GetSize (int &width, int &height) const
	{
		BITMAP bm;
		::GetObject (_hBitmap, sizeof (bm), &bm);
		width = bm.bmWidth;
		height = bm.bmHeight;
	}
protected:
	Bitmap (HBITMAP hBitmap)
		: _hBitmap (hBitmap)
	{}
	void Free ()
	{
		if (_hBitmap) 
			DeleteObject (_hBitmap);
	}

	HBITMAP	_hBitmap;
};

#endif
