//-------------------------------------
// Copyright (c) Reliable Software 1998
//-------------------------------------
#include "WinClass.h"
using namespace Win;

Class::Class (char const * name, Resources & res)
	: SimpleClass (name)
{
	_class.hInstance = res;
	SetDefaults ();
}

void Class::SetDefaults ()
{
    // Provide reasonable default values
    _class.cbSize = sizeof (WNDCLASSEX);
    _class.style = 0;
    _class.lpszClassName = GetName ();
    _class.lpfnWndProc = Procedure;
    _class.hIcon = 0;
    _class.hIconSm = 0;
    _class.lpszMenuName = 0;
    _class.cbClsExtra = 0;
    _class.cbWndExtra = 0;
    _class.hbrBackground = reinterpret_cast<HBRUSH> (COLOR_WINDOW + 1);
    _class.hCursor = ::LoadCursor (0, IDC_ARROW);
}

void Class::SetIcons (int id)
{
	Resources res (_class.hInstance);
	_stdIcon.Load (res, id);
	_smallIcon.Load (res, id);
	_class.hIcon = _stdIcon;
	_class.hIconSm = _smallIcon;
}

void Class::SetMenu (int id)
{
    _class.lpszMenuName = MAKEINTRESOURCE (id);
}

void Class::Register ()
{
    if (::RegisterClassEx (&_class) == 0)
        throw "Internal error: RegisterClassEx failed.";
}

