#if !defined (WINCTRL_H)
#define WINCTRL_H
//-------------------------------------
// Copyright (c) Reliable Software 1998
//-------------------------------------

#include "WinClass.h"
#include "Win.h"

namespace Win
{
	// Controller: base for all window controllers

	class Controller
	{
		friend LRESULT CALLBACK Class::Procedure (HWND hwnd, 
						UINT message, WPARAM wParam, LPARAM lParam);

		void SetWindowHandle (HWND hwnd) { _h = hwnd; }
	public:
		virtual void Create (CREATESTRUCT * create) {}
		virtual bool Destroy () { return false; }
		virtual bool SysCommand (int cmd) { return false; }
		virtual bool Size (int width, int height) { return false; }
		virtual bool Timer (int id, TIMERPROC * proc) { return false; }
		virtual bool MenuCommand (int cmdId, bool isAccel) { return false; }
		virtual bool CtrlCommand (int notifCode, int ctrlId, HWND hwnd) { return false; }
		virtual bool Paint (HDC hdc) { return false; }
	protected:
		H			  _h;
	};
}


#endif
