#if !defined (WINMAKER_H)
#define WINMAKER_H
//-------------------------------------
// Copyright (c) Reliable Software 1998
//-------------------------------------
#include <windows.h>

class Resources;

namespace Win
{
	class Class;
	class Controller;

	class Maker
	{
	public:
		Maker (Class const & winClass);
		void SetPosition (int x, int y, int width, int height);
		void SetCaption (char const * name) { _windowName = name; }

		void Create (Controller & controller, Resources & res);
		void Show (int nCmdShow = SW_SHOWNORMAL);
		operator HWND () { return _hwnd; }

	protected:
		void AddCreationData (void * data) { _data = data; }

		Win::Class const & _winClass;
		HWND        _hwnd;

		DWORD       _exStyle;       // extended window style
		char const *_windowName;    // pointer to window name
		DWORD       _style;         // window style
		int         _x;             // horizontal position of window
		int         _y;             // vertical position of window
		int         _width;         // window width  
		int         _height;        // window height
		HWND        _hWndParent;    // handle to parent or owner window
		HMENU       _hMenu;         // handle to menu, or child-window identifier
		void *      _data;          // pointer to window-creation data
	};
}

#endif
