//--------------------------------------
// Copyright (c) Reliable Software, 1999
//--------------------------------------
#include "Texture.h"
#include "lib\bitmap.h"
#include "lib\Canvas.h"
#include <cassert>

// Simplified version: supports only 24 bpp bitmaps

BitmapBits::BitmapBits (Bitmap const & bitmap)
:_colors (0)
{
	assert (_colors == 0);

	bitmap.GetSize (_width, _height);
	DesktopCanvas canvas;
	BITMAPINFOHEADER infoh;
	memset (&infoh, 0, sizeof (BITMAPINFOHEADER));
	infoh.biSize = sizeof (BITMAPINFOHEADER);
	// First, initialize the info header
	BITMAPINFO * info = reinterpret_cast<BITMAPINFO *> (&infoh);
	if (::GetDIBits (canvas, bitmap, 0, _height, 0, info, DIB_RGB_COLORS) == 0)
		throw "Cannot get bitmap info";
	if (infoh.biBitCount != 24)
		throw "BitmapBits: only 24 bits per pixel supported";
	assert (_width == infoh.biWidth);
	assert (_height == infoh.biHeight);

	// allocate space for bits
	_colors = new unsigned char [infoh.biSizeImage];

	if (::GetDIBits (canvas, bitmap, 0, _height, _colors, info, DIB_RGB_COLORS) == 0)
	{
		int err = ::GetLastError ();
		throw "Cannot get bitmap bits";
	}
	// three bytes per pixel
	_pitch = _width * 3;
	// round to the nearest long boundary
	_pitch = (_pitch + sizeof(long) - 1) & ~(sizeof (long) - 1);
	assert ((int)infoh.biSizeImage == _pitch * _height);
}

BitmapBits::~BitmapBits ()
{
	delete []_colors;
}

COLORREF BitmapBits::GetColor (int ix, int iy) const
{
	// bits are stored upside-down
	iy = _height - iy - 1;
	int offset = iy * _pitch + ix * 3;
	assert (offset < _pitch * _height * 3);
	int red = _colors [offset + 2];
	int green = _colors [offset + 1];
	int blue = _colors [offset];
	return RGB (red, green, blue);
}

// Texture Map

TextureMap::TextureMap (HINSTANCE hInst, int id)
: _bits (Bitmap (hInst, id))
{
}

// texture coordinates u, v are between 0 and 1

COLORREF TextureMap::GetTexel (double u, double v)
{
	int ix = static_cast<int> (u * _bits.Width ());
	int iy = static_cast<int> (v * _bits.Height ());
	return _bits.GetColor (ix, iy);
}
