#if !defined (MSGLOOP)
#define MSGLOOP
//---------------------------
// (c) Reliable Software 1999
//---------------------------

#include <windows.h>

class MessagePrepro
{
public:
	MessagePrepro ()
		: _hDlg (0), _hAccel (0)
	{}
	void SetKbdAccelerator (HACCEL hAccel) { _hAccel = hAccel; }
	// Use with modeless dialogs
	void SetDialogFilter (HWND hDlg) { _hDlg = hDlg; }
	int Pump (HWND appWnd);
private:
	HWND	_hDlg;
	HACCEL	_hAccel;
};

inline int MessagePrepro::Pump (HWND appWnd)
{
    MSG  msg;
    while (::GetMessage (&msg, 0, 0, 0 ))
    {
		if (_hDlg == 0 || !::IsDialogMessage (_hDlg, &msg))
		{
			if (_hAccel == 0 || !::TranslateAccelerator (appWnd, _hAccel, &msg))
			{
				::TranslateMessage (&msg);
				::DispatchMessage (&msg);
			}
		}
    }
    return msg.wParam;
}

#endif
