//-------------------------------------
// Copyright (c) Reliable Software 1999
//-------------------------------------

#include "Resources.h"

Icon::Icon (Resources res, char const * name, int dx, int dy, unsigned flag)
{
	_h = reinterpret_cast<HICON> (
		::LoadImage (res, name, IMAGE_ICON, dx, dy, flag));
}

Icon::Icon (Resources res, int id, int dx, int dy, unsigned flag)
{
	_h = reinterpret_cast<HICON> (
		::LoadImage (res, MAKEINTRESOURCE (id), IMAGE_ICON, dx, dy, flag));
}

Icon::~Icon ()
{
	::DestroyIcon (_h);
}

SmallIcon::SmallIcon (Resources res, int id)
{
	Load (res, id);
}

void SmallIcon::Load (Resources res, int id)
{
	_h = reinterpret_cast<HICON> (
		::LoadImage (res, 
			MAKEINTRESOURCE (id), 
			IMAGE_ICON,
			::GetSystemMetrics (SM_CXSMICON),
			::GetSystemMetrics (SM_CYSMICON),
			0));
}

StdIcon::StdIcon (Resources res, int id)
{
	Load (res, id);
}

void StdIcon::Load (Resources res, int id)
{
	_h = reinterpret_cast<HICON> (
		::LoadImage (res, 
			MAKEINTRESOURCE (id), 
			IMAGE_ICON,
			::GetSystemMetrics (SM_CXICON),
			::GetSystemMetrics (SM_CYICON),
			0));
}
