//-------------------------------------
// Copyright (c) Reliable Software 1998
//-------------------------------------
#include "WinMaker.h"
#include "WinClass.h"
#include "Resources.h"
#include <cassert>

using namespace Win;

Maker::Maker (Win::Class const & winClass)
  : _winClass (winClass),
    _hwnd (0),
    _exStyle (0),       // extended window style
    _windowName (0),    // pointer to window name
    _style (WS_OVERLAPPEDWINDOW), // window style
    _x (CW_USEDEFAULT), // horizontal position of window
    _y (0),             // vertical position of window
    _width (CW_USEDEFAULT), // window width  
    _height (0),        // window height
    _hWndParent (0),    // handle to parent or owner window
    _hMenu (0),         // handle to menu, or child-window identifier
    _data (0)           // pointer to window-creation data
{
}

void Maker::SetPosition (int x, int y, int width, int height)
{
    _x = x;
    _y = y;
    _width = width;
    _height = height;
}

void Maker::Create (Controller & controller, Resources & res)
{
	AddCreationData (&controller);
    _hwnd = ::CreateWindowEx (
        _exStyle,
        _winClass.GetName (),
        _windowName,
        _style,
        _x,
        _y,
        _width,
        _height,
        _hWndParent,
        _hMenu,
        res,
        _data);

    if (_hwnd == 0)
        throw "Internal error: Window Creation Failed.";
}

void Maker::Show (int cmdShow)
{
	assert (_hwnd != 0);
	::ShowWindow (_hwnd, cmdShow); 
	::UpdateWindow (_hwnd); 
}
