#if !defined (TIMER_H)
#define TIMER_H
//-------------------------------------
// Copyright Reliable Software (c) 1999
//-------------------------------------

#include "win.h"

namespace Win
{
	class Timer
	{
	public:
		Timer (HWND hwnd = 0, int id = -1) 
			: _hwnd (hwnd), _id (id)
		{}

		void Create (HWND hwnd, int id)
		{
			_hwnd.Init (hwnd);
			_id = id;
		}

		void Set (int milliSec)
		{
			_hwnd.SetTimer (_id, milliSec);
		}

		void Kill ()
		{
			_hwnd.KillTimer (_id);
		}
		int  GetId () const { return _id; }
	private:
		Win::H	_hwnd;
		int		_id;
	};
}

#endif