#include "Control.h"
//-------------------------------------
// Copyright Reliable Software (c) 1999
//-------------------------------------

#include "lib\WinMaker.h"
#include "lib\WinClass.h"
#include "lib\Resources.h"
#include "lib\MsgLoop.h"

#include <string>
#include <sstream>

#include "resources\resource.h"

int PASCAL WinMain
	(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR cmdParam, int cmdShow)
{
	try
	{
		Resources res (hInst);

		Win::Class topWinClass ("DirDemoClass", res);
		// Optionally modify class before registering
		topWinClass.SetIcons (ID_MAIN);
		topWinClass.Register ();

		Controller ctrl;
		MessagePrepro msgPrepro;

		Win::Maker topWin (topWinClass);
		topWin.SetPosition (10, 10, 130, 162);
		// Optionally modify window parameters before creating
		topWin.SetCaption ("Direct");
		topWin.Create (ctrl, res);
		topWin.Show (cmdShow);
		// The main message loop
		return msgPrepro.Pump (topWin);
	}
	catch (char const * msg)
	{
		::MessageBox (0, msg, "Fatal Error", MB_OK | MB_ICONEXCLAMATION);
	}
	catch (...)
	{
		::MessageBox (0, "Unknown", "Fatal Error", MB_OK | MB_ICONEXCLAMATION);
	}
	return 0;
}
