//-------------------------------------
// Copyright Reliable Software (c) 1999
//-------------------------------------
#include "View.h"
#include "World.h"
#include "lib\win.h"
#include <cassert>

View::View () 
: _world (0)
{}

void View::Create (HWND h, World * world)
{
	_world = world;
	// Set coopration with Windows
	_draw.SetCoopNormal (h);
}

void View::Paint (HWND h)
{
	if (_dx == 0 || _dy == 0)
		return;
	// Clip to window
	Direct::Clipper clipper (_draw);
	clipper.SetHWnd (h);
	// Screen surface
	Direct::PrimarySurface surf (_draw);
	surf.SetClipper (clipper);
	Direct::WinRect rect (h);
	// Blit from back surface to screen
	surf.BltFrom (_backSurface, &rect);
}

void View::Size (HWND h, int width, int height)
{
	_dx = width;
	_dy = height;
	if (_dx == 0 || _dy == 0)
		return;
	_backSurface = Direct::OffScreenSurface (_draw, _dx, _dy);
}

void View::Update ()
{
	if (_dx == 0 || _dy == 0)
		return;
	try
	{
		// white background
		_backSurface.Fill (RGB (255, 255, 255));

		{
			// Get direct access to back surface
			Direct::SurfaceBuf buf (_backSurface);
			// draw bitmap within a centered square
			int side = 100;
			if (_dx < side)
				side = _dx;
			if (_dy < side)
				side = _dy;
			int xOff = (_dx - side) / 2;
			int yOff = (_dy - side) / 2;
			assert (xOff >= 0);
			assert (yOff >= 0);
			double dxInv = 1.0 / side;
			double dyInv = 1.0 / side;
			for (int i = 0; i < side; ++i)
			{
				for (int j = 0; j < side; ++j)
				{
					double u = dxInv * i;
					double v = dyInv * j;
					COLORREF color = _world->GetTexel (u, v);
					// draw pixel directly
					buf.SetPixel (xOff + i, yOff + j, color);
				}
			}
		}
		// Paint will blit the image to screen
	}
	catch (char const * msg)
	{
		::MessageBox (0, msg, "Viewer error", MB_OK | MB_ICONERROR);
		throw;
	}
	catch (...)
	{
		::MessageBox (0, "Unknown error", "Viewer error", MB_OK | MB_ICONERROR);
		throw;
	}
}

