//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#ifndef _MODEL_H_INCLUDED
#define _MODEL_H_INCLUDED

#include <windows.h>
#include "shape.h"

class Model
{
public:
    Model ()
		:_currentShape   (SHAPE_LINE)
    {}

	ShapeStore const & GetShapes () const		{ return _shapes; }
    void CreateNewShape     ( POINTS startPos);
    void SetEndPosition     ( POINTS pos );

    void Clear              ()                  { _shapes.EmptyOut();      }

    void SetColor           ( COLORREF color)   { _pd.SetColor(color);     }
    void SetStyle           ( DWORD style)      { _pd.SetStyle(style);     }
    void SetPenWidth        ( int width)        { _pd.SetWidth(width);     }
    void SetShapeType       ( SHAPE_TYPE type)  { _currentShape = type;    }
protected:
    ShapeStore      _shapes;

    PenDescription  _pd;
    SHAPE_TYPE		_currentShape;
};

#endif // _MODEL_H_INCLUDED
