//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#ifndef _pens_H_INCLUDED
#define _pens_H_INCLUDED

#include <windows.h>

static const COLORREF WHITE_COLOR  = PALETTERGB(255,255,255);
static const COLORREF BLACK_COLOR  = PALETTERGB(0,0,0);
static const COLORREF GREEN_COLOR  = PALETTERGB(0,128,0);
static const COLORREF BLUE_COLOR   = PALETTERGB(0,0,128);
static const COLORREF RED_COLOR    = PALETTERGB(128,0,0);
 
class PenDescription
{
public:
    PenDescription(DWORD style = PS_SOLID, int width = 1, COLORREF color = BLACK_COLOR)
    :   _style(style),
        _width(width),
        _color(color)
    {}
    void    SetStyle(DWORD      style)  {_style = style;}
    void    SetWidth(int        width)  {_width = width;}
    void    SetColor(COLORREF   color)  {_color = color;}

    DWORD       Style() const   {return _style;}
    int         Width() const   {return _width;}
    COLORREF    Color() const   {return _color;}
private:
    DWORD       _style;
    int         _width;
    COLORREF    _color;
};

class StockObject
{
public:
    StockObject (HDC hdc, int type)
      : _hdc(hdc)
    {
        _hObjOld = SelectObject (_hdc, GetStockObject (type));
    }

    ~StockObject ()
    {
        SelectObject (_hdc, _hObjOld);
    }
private:
    HGDIOBJ  _hObjOld;
    HDC      _hdc;
};

class Pen
{
public:
    Pen (int style = PS_SOLID, int width = 0, COLORREF color = BLACK_COLOR )
    {
        _hPen = CreatePen (style, width, color);
    }
    Pen (PenDescription const & pd)
    {
        _hPen = CreatePen (pd.Style(), pd.Width(), pd.Color());
    }
    ~Pen ()
    {
        DeleteObject (_hPen);
    }
    operator HPEN () { return _hPen; }
private:
    HPEN    _hPen;
};

class PenHolder
{
public:
    PenHolder (HDC hdc, HPEN hPen)
        : _hdc (hdc)
    {
        _hPenOld = (HPEN)SelectObject (_hdc, hPen);
    }
    ~PenHolder ()
    {
        SelectObject (_hdc, _hPenOld);
    }
private:
    HDC     _hdc;
    HPEN    _hPenOld;
};

class SolidBrush
{
public:
    SolidBrush (COLORREF color = 0)
    {
        _hBrush = CreateSolidBrush (color);
    }
    ~SolidBrush ()
    {
        DeleteObject (_hBrush);
    }
    operator HBRUSH () { return _hBrush; }
private:
    HBRUSH  _hBrush;
};

class HatchedBrush
{
public:
    HatchedBrush (int style = HS_HORIZONTAL, COLORREF color = BLACK_COLOR)
    {
        _hBrush = CreateHatchBrush (style, color);
    }
    ~HatchedBrush ()
    {
        DeleteObject (_hBrush);
    }
    operator HBRUSH () { return _hBrush; }
private:
    HBRUSH  _hBrush;
};

class BrushHolder
{
public:
    BrushHolder (HDC hdc, HBRUSH brush)
    : _hdc (hdc)
    {
        _hBrushOld = (HBRUSH)SelectObject (_hdc, brush);
    }
    ~BrushHolder ()
    {
        SelectObject (_hdc, _hBrushOld);
    }
private:
    HDC     _hdc;
    HBRUSH  _hBrushOld;
};

#endif // _pens_H_INCLUDED
