//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#include "shape.h"

class ModeSetter
{
public:
    ModeSetter ( HDC hdc, int mode = R2_COPYPEN )
    : _hdc (hdc)
    {
        _modeOld = GetROP2 ( _hdc );
        SetROP2 ( _hdc, mode );
    }
    ~ModeSetter ()
    {
        SetROP2 ( _hdc, _modeOld );
    }
private:
    HDC _hdc;
    int _modeOld;
};

Shape::Shape(PenDescription & pd, SHAPE_TYPE vo, Point origin)
:	_type(vo),
    _pd(pd),
    _previousEndPos(origin)
{
    _boundary.left  = _boundary.right   = origin.x;
    _boundary.top   = _boundary.bottom  = origin.y;
}

void
Shape::SetEndPosition(int x, int y)
{
    _previousEndPos.x = _boundary.right;
    _previousEndPos.y = _boundary.bottom;

    _boundary.right     = x;
    _boundary.bottom    = y;
}

void
RectShape::Draw(Canvas & canvas, BOOL finalDraw) const
{
    if (finalDraw)
	    canvas.Rect(_boundary, _pd);
    else
        canvas.ThinRect(_boundary);
}

void
RectShape::DrawPrevious(Canvas & canvas) const
{
    // set the boundary to the previous position
    RECT r;

    r.left      = _boundary.left;
    r.top       = _boundary.top;
    r.right     = _previousEndPos.x;
    r.bottom    = _previousEndPos.y;

    canvas.ThinRect(r);
}

void
EllipseShape::Draw(Canvas & canvas, BOOL finalDraw) const
{
    if (finalDraw)
	    canvas.Oval(_boundary, _pd);
    else
        canvas.ThinOval(_boundary);
}

void
EllipseShape::DrawPrevious(Canvas & canvas) const
{
    // set the boundary to the previous position
    RECT r;

    r.left      = _boundary.left;
    r.top       = _boundary.top;
    r.right     = _previousEndPos.x;
    r.bottom    = _previousEndPos.y;

    canvas.ThinOval(r);
}

void
CircleShape::Draw(Canvas & canvas, BOOL finalDraw) const
{
    if (finalDraw)
    	canvas.Circle(_boundary, _pd);
    else
        canvas.ThinCircle(_boundary);
}

void
CircleShape::DrawPrevious(Canvas & canvas) const
{
    // set the boundary to the previous position
    RECT r;

    r.left      = _boundary.left;
    r.top       = _boundary.top;
    r.right     = _previousEndPos.x;
    r.bottom    = _previousEndPos.y;

    canvas.ThinCircle(r);
}

void
LineShape::Draw(Canvas & canvas, BOOL finalDraw) const
{
    POINT start, end;
    start.x = _boundary.left;
    start.y = _boundary.top;
    end.x   = _boundary.right;
    end.y   = _boundary.bottom;

    if (finalDraw)
	    canvas.Line(start, end, _pd);
    else
        canvas.ThinLine(start, end);
}

void
LineShape::DrawPrevious(Canvas & canvas) const
{
    // set the boundary to the previous position
    POINT start;
    start.x = _boundary.left;
    start.y = _boundary.top;

    canvas.ThinLine(start, _previousEndPos);
}

int
ShapeStore::EmptyOut ()
{
	delete [] _data;
	_data		= 0;
	_count		= 0;
	_capacity	= 0;
	return(0);
}

int
ShapeStore::Append( SHAPE_TYPE type, PenDescription & pd, POINTS pos)
{
	Point p;
	p = pos;
	Shape * s = 0;
	switch (type)
	{
	case SHAPE_RECT:
		s = new RectShape(pd, p);
		break;
	case SHAPE_ELLIPSE:
		s = new EllipseShape(pd, p);
		break;
	case SHAPE_CIRCLE:
		s = new CircleShape(pd, p);
		break;
	case SHAPE_LINE:
		s = new LineShape(pd, p);
		break;
	}
	if (s)
	{
		if (_count == _capacity)
			Grow();
		_data[_count++] = s;
	}
	return _count;
}

void
ShapeStore::Grow(int minimumCapacity)
{
	_capacity = max (minimumCapacity, 2 * _capacity);
	if (_capacity)
	{
		Shape **newData = new Shape*[_capacity];
		int i;

		for (i=0;i<_count;i++)
			newData[i] = _data[i];

		delete [] _data;
		_data = newData;
	}
}

void
ShapeStore::Draw(Canvas & canvas) const
{
	if (!_count)
		return;

	for (int i=0; i<_count;i++)
		_data[i]->Draw(canvas, TRUE);
}

void
ShapeStore::DrawUpdate(Canvas & canvas) const
{
	if (!_count)
		return;

    Shape * last = _data[_count - 1];

    // Erase the old shape
    ModeSetter s(canvas, R2_NOTXORPEN);
    last->DrawPrevious(canvas);
    // Draw the new shape
    last->Draw(canvas, FALSE);
}

void
ShapeStore::DrawLast(Canvas & canvas) const
{
	if (!_count)
		return;

    Shape * last = _data[_count - 1];

    // Erase the old shape
    {
        ModeSetter s(canvas, R2_NOTXORPEN);
        last->DrawPrevious(canvas);
    }
    // Draw the final (real) shape, and make sure the
    // final shape shows above all others.
    last->Draw(canvas, TRUE);
}
