//------------------------------------
//  (c) 1998 Reliable Software
//------------------------------------
#ifndef _VIEW_H_INCLUDED
#define _VIEW_H_INCLUDED

#include <windows.h>
#include "shape.h"
#include "canvas.h"

class View
{
public:
    View()
    :   _width(0),
        _height(0)
    {}
    void Clear()
    {}
    void SetSize (int newWidth, int newHeight)
    {
        _width  = newWidth;
        _height = newHeight;
    }
    void Paint (Canvas& canvas, ShapeStore const & shapes)
    {
        shapes.Draw(canvas);
    }
    void Update (Canvas& canvas, ShapeStore const & shapes)
    {
        shapes.DrawUpdate(canvas);
    }
    void FinalUpdate (Canvas& canvas, ShapeStore const & shapes)
    {
        shapes.DrawLast(canvas);
    }
    int GetWidth () const {return _width;}
    int GetHeight() const {return _height;}
protected:
   int  _width;
   int  _height;
};

#endif // _VIEW_H_INCLUDED
